/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.ParameterConstraint;
import io.github.microcks.domain.ParameterLocation;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.ParameterConstraintUtil;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.JsonEvaluationSpecification;
import io.github.microcks.util.dispatcher.JsonExpressionEvaluator;
import io.github.microcks.util.dispatcher.JsonMappingException;
import io.github.microcks.util.script.ScriptEngineBinder;
import io.github.microcks.web.DispatchContext;
import io.github.microcks.web.MockControllerCommons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;

@org.springframework.web.bind.annotation.RestController
@RequestMapping(value={"/rest"})
public class RestController {
    private static Logger log = LoggerFactory.getLogger(RestController.class);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${mocks.enable-invocation-stats}")
    private final Boolean enableInvocationStats = null;
    @Value(value="${mocks.rest.enable-cors-policy}")
    private final Boolean enableCorsPolicy = null;

    @RequestMapping(value={"/{service}/{version}/**"}, method={RequestMethod.HEAD, RequestMethod.OPTIONS, RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public ResponseEntity<?> execute(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @RequestParam(value="delay", required=false) Long delay, @RequestBody(required=false) String body, HttpServletRequest request) {
        String trimmedResourcePath;
        log.info("Servicing mock response for service [{}, {}] on uri {} with verb {}", new Object[]{serviceName, version, request.getRequestURI(), request.getMethod()});
        log.debug("Request body: {}", (Object)body);
        long startTime = System.currentTimeMillis();
        String requestURI = request.getRequestURI();
        String serviceAndVersion = null;
        String resourcePath = null;
        serviceAndVersion = "/" + UriUtils.encodeFragment((String)serviceName, (String)"UTF-8") + "/" + version;
        resourcePath = requestURI.substring(requestURI.indexOf(serviceAndVersion) + serviceAndVersion.length());
        log.debug("Found resourcePath: {}", (Object)resourcePath);
        if (serviceName.contains("+")) {
            serviceName = serviceName.replace('+', ' ');
        }
        if (resourcePath.contains("+")) {
            resourcePath = resourcePath.replace("+", "%20");
        }
        if ((trimmedResourcePath = resourcePath).endsWith("/")) {
            trimmedResourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        Service service = this.serviceRepository.findByNameAndVersion(serviceName, version);
        Operation rOperation = null;
        for (Operation operation : service.getOperations()) {
            if (!operation.getMethod().equals(request.getMethod().toUpperCase()) || operation.getResourcePaths() == null || !operation.getResourcePaths().contains(resourcePath) && !operation.getResourcePaths().contains(trimmedResourcePath)) continue;
            rOperation = operation;
            break;
        }
        if (rOperation == null) {
            for (Operation operation : service.getOperations()) {
                if (!operation.getMethod().equals(request.getMethod().toUpperCase()) || operation.getResourcePaths() == null) continue;
                String operationPattern = this.getURIPattern(operation.getName());
                operationPattern = operationPattern.replaceAll("\\{[\\w-]+\\}", "([^/])+");
                if (!resourcePath.matches(operationPattern = operationPattern.replaceAll("(/:[^:^/]+)", "\\/([^/]+)"))) continue;
                rOperation = operation;
                break;
            }
        }
        if (rOperation != null) {
            log.debug("Found a valid operation {} with rules: {}", (Object)rOperation.getName(), (Object)rOperation.getDispatcherRules());
            String violationMsg = this.validateParameterConstraintsIfAny(rOperation, request);
            if (violationMsg != null) {
                return new ResponseEntity((Object)(violationMsg + ". Check parameter constraints."), HttpStatus.BAD_REQUEST);
            }
            String dispatcher = rOperation.getDispatcher();
            String dispatcherRules = rOperation.getDispatcherRules();
            FallbackSpecification fallback = MockControllerCommons.getFallbackIfAny(rOperation);
            if (fallback != null) {
                dispatcher = fallback.getDispatcher();
                dispatcherRules = fallback.getDispatcherRules();
            }
            DispatchContext dispatchContext = this.computeDispatchCriteria(dispatcher, dispatcherRules, this.getURIPattern(rOperation.getName()), UriUtils.decode((String)resourcePath, (String)"UTF-8"), request, body);
            log.debug("Dispatch criteria for finding response is {}", (Object)dispatchContext.dispatchCriteria());
            Response response = null;
            List<Response> responses = this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
            response = this.getResponseByMediaType(responses, request);
            if (response == null) {
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
                response = this.getResponseByMediaType(responses, request);
            }
            if (response == null && fallback != null) {
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), fallback.getFallback());
                response = this.getResponseByMediaType(responses, request);
            }
            if (response == null) {
                log.debug("No responses found so far, tempting with just bare operationId...");
                responses = this.responseRepository.findByOperationId(IdBuilder.buildOperationId((Service)service, (Operation)rOperation));
                if (!responses.isEmpty()) {
                    response = this.getResponseByMediaType(responses, request);
                }
            }
            if (response != null) {
                HttpStatus status = response.getStatus() != null ? HttpStatus.valueOf((int)Integer.parseInt(response.getStatus())) : HttpStatus.OK;
                HttpHeaders responseHeaders = new HttpHeaders();
                if (response.getMediaType() != null) {
                    responseHeaders.setContentType(MediaType.valueOf((String)(response.getMediaType() + ";charset=UTF-8")));
                }
                this.recopyHeadersFromParameterConstraints(rOperation, request, responseHeaders);
                if (response.getHeaders() != null) {
                    for (Header header : response.getHeaders()) {
                        if ("Location".equals(header.getName())) {
                            String location = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/rest" + serviceAndVersion + (String)header.getValues().iterator().next();
                            responseHeaders.add(header.getName(), location);
                            continue;
                        }
                        if ("Transfer-Encoding".equalsIgnoreCase(header.getName())) continue;
                        responseHeaders.put(header.getName(), new ArrayList(header.getValues()));
                    }
                }
                String responseContent = MockControllerCommons.renderResponseContent(body, resourcePath, request, dispatchContext.requestContext(), response);
                if (delay == null && rOperation.getDefaultDelay() != null) {
                    delay = rOperation.getDefaultDelay();
                }
                MockControllerCommons.waitForDelay(startTime, delay);
                if (this.enableInvocationStats.booleanValue()) {
                    MockControllerCommons.publishMockInvocation(this.applicationContext, this, service, response, startTime);
                }
                return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, status);
            }
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        if (this.enableCorsPolicy.booleanValue() && "OPTIONS".equals(request.getMethod().toUpperCase())) {
            log.debug("No valid operation found but Microcks configured to apply CORS policy");
            return this.handleCorsRequest(request);
        }
        log.debug("No valid operation found and Microcks configured to not apply CORS policy...");
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    private String validateParameterConstraintsIfAny(Operation rOperation, HttpServletRequest request) {
        if (rOperation.getParameterConstraints() != null) {
            for (ParameterConstraint constraint : rOperation.getParameterConstraints()) {
                String violationMsg = ParameterConstraintUtil.validateConstraint(request, constraint);
                if (violationMsg == null) continue;
                return violationMsg;
            }
        }
        return null;
    }

    private DispatchContext computeDispatchCriteria(String dispatcher, String dispatcherRules, String uriPattern, String resourcePath, HttpServletRequest request, String body) {
        Object dispatchCriteria = null;
        HashMap<String, Object> requestContext = null;
        if (dispatcher != null) {
            switch (dispatcher) {
                case "SEQUENCE": {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(dispatcherRules, uriPattern, resourcePath);
                    break;
                }
                case "SCRIPT": {
                    ScriptEngineManager sem = new ScriptEngineManager();
                    requestContext = new HashMap<String, Object>();
                    try {
                        ScriptEngine se = sem.getEngineByExtension("groovy");
                        ScriptEngineBinder.bindEnvironment(se, body, requestContext, request);
                        dispatchCriteria = (String)se.eval(dispatcherRules);
                    }
                    catch (Exception e) {
                        log.error("Error during Script evaluation", (Throwable)e);
                    }
                    break;
                }
                case "URI_PARAMS": {
                    String fullURI = request.getRequestURL() + "?" + request.getQueryString();
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIParams(dispatcherRules, fullURI);
                    break;
                }
                case "URI_PARTS": {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(dispatcherRules, uriPattern, resourcePath);
                    break;
                }
                case "URI_ELEMENTS": {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(dispatcherRules, uriPattern, resourcePath);
                    String fullURI = request.getRequestURL() + "?" + request.getQueryString();
                    dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.extractFromURIParams(dispatcherRules, fullURI);
                    break;
                }
                case "JSON_BODY": {
                    try {
                        JsonEvaluationSpecification specification = JsonEvaluationSpecification.buildFromJsonString(dispatcherRules);
                        dispatchCriteria = JsonExpressionEvaluator.evaluate(body, specification);
                        break;
                    }
                    catch (JsonMappingException jme) {
                        log.error("Dispatching rules of operation cannot be interpreted as JsonEvaluationSpecification", (Throwable)jme);
                    }
                }
            }
        }
        return new DispatchContext((String)dispatchCriteria, (Map<String, Object>)requestContext);
    }

    private void recopyHeadersFromParameterConstraints(Operation rOperation, HttpServletRequest request, HttpHeaders responseHeaders) {
        if (rOperation.getParameterConstraints() != null) {
            for (ParameterConstraint constraint : rOperation.getParameterConstraints()) {
                String value;
                if (ParameterLocation.header != constraint.getIn() || !constraint.isRecopy() || (value = request.getHeader(constraint.getName())) == null) continue;
                responseHeaders.set(constraint.getName(), value);
            }
        }
    }

    private Response getResponseByMediaType(List<Response> responses, HttpServletRequest request) {
        if (!responses.isEmpty()) {
            String accept = request.getHeader("Accept");
            return responses.stream().filter(r -> StringUtils.isNotEmpty((String)accept) ? accept.equals(r.getMediaType()) : true).findFirst().orElse(responses.get(0));
        }
        return null;
    }

    private String getURIPattern(String operationName) {
        if (operationName.startsWith("GET ") || operationName.startsWith("POST ") || operationName.startsWith("PUT ") || operationName.startsWith("DELETE ") || operationName.startsWith("PATCH ") || operationName.startsWith("OPTIONS ")) {
            return operationName.substring(operationName.indexOf(32) + 1);
        }
        return operationName;
    }

    private ResponseEntity<Object> handleCorsRequest(HttpServletRequest request) {
        ArrayList accessControlHeaders = new ArrayList();
        Collections.list(request.getHeaders("Access-Control-Request-Headers")).forEach(header -> accessControlHeaders.add(header));
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setAccessControlAllowHeaders(accessControlHeaders);
        requestHeaders.setAccessControlExposeHeaders(accessControlHeaders);
        ResponseEntity response = ResponseEntity.noContent().header("Access-Control-Allow-Origin", new String[]{"*"}).header("Access-Control-Allow-Methods", new String[]{"POST, PUT, GET, OPTIONS, DELETE, PATCH"}).headers(requestHeaders).header("Access-Allow-Credentials", new String[]{"true"}).header("Access-Control-Max-Age", new String[]{"3600"}).header("Vary", new String[]{"Accept-Encoding, Origin"}).build();
        return response;
    }
}

