/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.ParameterConstraint;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.ParameterConstraintUtil;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.JsonEvaluationSpecification;
import io.github.microcks.util.dispatcher.JsonExpressionEvaluator;
import io.github.microcks.util.dispatcher.JsonMappingException;
import io.github.microcks.util.graphql.GraphQLHttpRequest;
import io.github.microcks.util.script.ScriptEngineBinder;
import io.github.microcks.web.DispatchContext;
import io.github.microcks.web.MockControllerCommons;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/graphql"})
public class GraphQLController {
    private static Logger log = LoggerFactory.getLogger(GraphQLController.class);
    private static final String INTROSPECTION_SELECTION = "__schema";
    private final ServiceRepository serviceRepository;
    private final ResponseRepository responseRepository;
    private final ResourceRepository resourceRepository;
    private final ApplicationContext applicationContext;
    @org.springframework.beans.factory.annotation.Value(value="${mocks.enable-invocation-stats}")
    private final Boolean enableInvocationStats = null;
    private final Parser requestParser = new Parser();
    private final SchemaParser schemaParser = new SchemaParser();
    private final SchemaGenerator schemaGenerator = new SchemaGenerator();
    private final ObjectMapper mapper = new ObjectMapper();

    public GraphQLController(ServiceRepository serviceRepository, ResponseRepository responseRepository, ResourceRepository resourceRepository, ApplicationContext applicationContext) {
        this.serviceRepository = serviceRepository;
        this.responseRepository = responseRepository;
        this.resourceRepository = resourceRepository;
        this.applicationContext = applicationContext;
    }

    @RequestMapping(value={"/{service}/{version}/**"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<?> execute(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @RequestParam(value="delay", required=false) Long delay, @RequestBody(required=false) String body, HttpServletRequest request) {
        Document graphqlRequest;
        GraphQLHttpRequest graphqlHttpReq;
        Service service;
        log.info("Servicing GraphQL mock response for service [{}, {}]", (Object)serviceName, (Object)version);
        log.debug("Request body: {}", (Object)body);
        long startTime = System.currentTimeMillis();
        if (serviceName.contains("+")) {
            serviceName = serviceName.replace('+', ' ');
        }
        if ((service = this.serviceRepository.findByNameAndVersion(serviceName, version)) == null) {
            return new ResponseEntity((Object)String.format("The service %s with version %s does not exist!", serviceName, version), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        try {
            graphqlHttpReq = GraphQLHttpRequest.from(body, request);
            graphqlRequest = this.requestParser.parseDocument(graphqlHttpReq.getQuery());
        }
        catch (Exception e) {
            log.error("Error parsing GraphQL request: {}", (Object)e.getMessage());
            return new ResponseEntity((Object)("Error parsing GraphQL request: " + e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        Definition graphqlDef = (Definition)graphqlRequest.getDefinitions().get(0);
        OperationDefinition graphqlOperation = (OperationDefinition)graphqlDef;
        log.debug("Got this graphqlOperation: {}", (Object)graphqlOperation);
        String operationType = graphqlOperation.getOperation().toString();
        if ("QUERY".equals(operationType) && INTROSPECTION_SELECTION.equals(((Field)graphqlOperation.getSelectionSet().getSelections().get(0)).getName())) {
            log.info("Handling GraphQL schema introspection query...");
            Resource graphqlSchema = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.GRAPHQL_SCHEMA).get(0);
            TypeDefinitionRegistry typeDefinitionRegistry = this.schemaParser.parse(graphqlSchema.getContent());
            GraphQLSchema graphQLSchema = this.schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, RuntimeWiring.MOCKED_WIRING);
            GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
            ExecutionResult executionResult = graphQL.execute(graphqlHttpReq.getQuery());
            String responseContent = null;
            try {
                responseContent = this.mapper.writeValueAsString((Object)executionResult);
            }
            catch (JsonProcessingException jpe) {
                log.error("Unknown Json processing exception", (Throwable)jpe);
                return new ResponseEntity((Object)jpe.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseContent, (HttpStatusCode)HttpStatus.OK);
        }
        ArrayList<GraphQLQueryResponse> graphqlResponses = new ArrayList<GraphQLQueryResponse>();
        Long[] maxDelay = new Long[]{delay == null ? 0L : delay};
        for (Object selection : graphqlOperation.getSelectionSet().getSelections()) {
            GraphQLQueryResponse graphqlResponse = null;
            try {
                graphqlResponse = this.processGraphQLQuery(service, operationType, (Field)selection, graphqlRequest.getDefinitionsOfType(FragmentDefinition.class), body, graphqlHttpReq, request);
                graphqlResponses.add(graphqlResponse);
                if (graphqlResponse.getOperationDelay() == null || graphqlResponse.getOperationDelay() <= maxDelay[0]) continue;
                maxDelay[0] = graphqlResponse.getOperationDelay();
            }
            catch (GraphQLQueryProcessingException e) {
                log.error("Caught a GraphQL processing exception", (Throwable)e);
                return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)e.getStatus());
            }
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        for (GraphQLQueryResponse response : graphqlResponses) {
            if (response.getResponse().getHeaders() == null) continue;
            for (Header header : response.getResponse().getHeaders()) {
                if ("Transfer-Encoding".equalsIgnoreCase(header.getName())) continue;
                responseHeaders.put(header.getName(), new ArrayList(header.getValues()));
            }
        }
        if (!responseHeaders.containsKey((Object)"Content-Type") && !responseHeaders.containsKey((Object)"content-type")) {
            responseHeaders.put("Content-Type", List.of("application/json"));
        }
        MockControllerCommons.waitForDelay(startTime, maxDelay[0]);
        if (this.enableInvocationStats.booleanValue()) {
            MockControllerCommons.publishMockInvocation(this.applicationContext, this, service, ((GraphQLQueryResponse)graphqlResponses.get(0)).getResponse(), startTime);
        }
        String responseContent = null;
        JsonNode responseNode = ((GraphQLQueryResponse)graphqlResponses.get(0)).getJsonResponse();
        if (graphqlResponses.size() > 1) {
            ObjectNode aggregated = this.mapper.createObjectNode();
            ObjectNode dataNode = aggregated.putObject("data");
            for (GraphQLQueryResponse response : graphqlResponses) {
                dataNode.set((String)StringUtils.defaultIfBlank((CharSequence)response.getAlias(), (CharSequence)response.getOperationName()), response.getJsonResponse().path("data").path(response.getOperationName()).deepCopy());
            }
            responseNode = aggregated;
        }
        try {
            responseContent = this.mapper.writeValueAsString((Object)responseNode);
        }
        catch (JsonProcessingException e) {
            log.error("Unknown Json processing exception", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    protected GraphQLQueryResponse processGraphQLQuery(Service service, String operationType, Field graphqlField, List<FragmentDefinition> fragmentDefinitions, String body, GraphQLHttpRequest graphqlHttpReq, HttpServletRequest request) throws GraphQLQueryProcessingException {
        GraphQLQueryResponse result = new GraphQLQueryResponse();
        String operationName = graphqlField.getName();
        result.setAlias(graphqlField.getAlias());
        result.setOperationName(operationName);
        log.debug("Processing a '{}' operation with name '{}'", (Object)operationType, (Object)operationName);
        Operation rOperation = null;
        for (Operation operation : service.getOperations()) {
            if (!operation.getMethod().equals(operationType) || !operation.getName().equals(operationName)) continue;
            rOperation = operation;
            break;
        }
        if (rOperation != null) {
            log.debug("Found a valid operation {} with rules: {}", (Object)rOperation.getName(), (Object)rOperation.getDispatcherRules());
            String violationMsg = this.validateParameterConstraintsIfAny(rOperation, request);
            if (violationMsg != null) {
                throw new GraphQLQueryProcessingException(violationMsg + ". Check parameter constraints.", HttpStatus.BAD_REQUEST);
            }
            String dispatcher = rOperation.getDispatcher();
            String dispatcherRules = rOperation.getDispatcherRules();
            FallbackSpecification fallback = MockControllerCommons.getFallbackIfAny(rOperation);
            if (fallback != null) {
                dispatcher = fallback.getDispatcher();
                dispatcherRules = fallback.getDispatcherRules();
            }
            DispatchContext dispatchContext = this.computeDispatchCriteria(dispatcher, dispatcherRules, (Selection<?>)graphqlField, graphqlHttpReq.getVariables(), request, body);
            log.debug("Dispatch criteria for finding response is {}", (Object)dispatchContext.dispatchCriteria());
            Response response = null;
            List<Response> responses = this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
            if (!responses.isEmpty()) {
                response = responses.get(0);
            }
            if (response == null) {
                log.debug("No responses with dispatch criteria, trying the name...");
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
                if (!responses.isEmpty()) {
                    response = responses.get(0);
                }
            }
            if (response == null && fallback != null) {
                log.debug("No responses till now so far, applying the fallback...");
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), fallback.getFallback());
                if (!responses.isEmpty()) {
                    response = responses.get(0);
                }
            }
            if (response == null) {
                log.debug("No responses found so far, tempting with just bare operationId...");
                responses = this.responseRepository.findByOperationId(IdBuilder.buildOperationId((Service)service, (Operation)rOperation));
                if (!responses.isEmpty()) {
                    response = responses.get(0);
                }
            }
            if (response != null) {
                result.setResponse(response);
                result.setOperationDelay(rOperation.getDefaultDelay());
                HashMap<String, String> evaluableHeaders = new HashMap<String, String>();
                if (response.getHeaders() != null) {
                    for (Header header : response.getHeaders()) {
                        evaluableHeaders.put(header.getName(), request.getHeader(header.getName()));
                    }
                }
                String responseContent = MockControllerCommons.renderResponseContent(body, null, evaluableHeaders, dispatchContext.requestContext(), response);
                try {
                    JsonNode responseJson = this.mapper.readTree(responseContent);
                    this.filterFieldSelection(graphqlField.getSelectionSet(), fragmentDefinitions, responseJson.get("data").get(operationName));
                    result.setJsonResponse(responseJson);
                }
                catch (JsonProcessingException pe) {
                    log.error("JsonProcessingException while filtering response according GraphQL field selection", (Throwable)pe);
                    throw new GraphQLQueryProcessingException("Exception while filtering response JSON", HttpStatus.INTERNAL_SERVER_ERROR);
                }
                return result;
            }
            log.debug("No response found. Throwing a BAD_REQUEST exception...");
            throw new GraphQLQueryProcessingException("No matching response found", HttpStatus.BAD_REQUEST);
        }
        log.debug("No valid operation found. Throwing a NOT_FOUND exception...");
        throw new GraphQLQueryProcessingException("No '" + operationName + "' operation found", HttpStatus.NOT_FOUND);
    }

    private String validateParameterConstraintsIfAny(Operation rOperation, HttpServletRequest request) {
        if (rOperation.getParameterConstraints() != null) {
            for (ParameterConstraint constraint : rOperation.getParameterConstraints()) {
                String violationMsg = ParameterConstraintUtil.validateConstraint(request, constraint);
                if (violationMsg == null) continue;
                return violationMsg;
            }
        }
        return null;
    }

    private DispatchContext computeDispatchCriteria(String dispatcher, String dispatcherRules, Selection<?> graphqlSelection, JsonNode requestVariables, HttpServletRequest request, String body) {
        String dispatchCriteria = null;
        HashMap<String, Object> requestContext = null;
        if (dispatcher != null) {
            switch (dispatcher) {
                case "SCRIPT": {
                    ScriptEngineManager sem = new ScriptEngineManager();
                    requestContext = new HashMap<String, Object>();
                    try {
                        ScriptEngine se = sem.getEngineByExtension("groovy");
                        ScriptEngineBinder.bindEnvironment(se, body, requestContext, request);
                        dispatchCriteria = (String)se.eval(dispatcherRules);
                    }
                    catch (Exception e) {
                        log.error("Error during Script evaluation", (Throwable)e);
                    }
                    break;
                }
                case "QUERY_ARGS": {
                    Field field = (Field)graphqlSelection;
                    HashMap<String, String> queryParams = new HashMap<String, String>();
                    for (Argument arg : field.getArguments()) {
                        Value value = arg.getValue();
                        if (value instanceof StringValue) {
                            StringValue stringArg = (StringValue)value;
                            queryParams.put(arg.getName(), stringArg.getValue());
                            continue;
                        }
                        value = arg.getValue();
                        if (!(value instanceof VariableReference)) continue;
                        VariableReference varRef = (VariableReference)value;
                        if (requestVariables == null) continue;
                        queryParams.put(arg.getName(), requestVariables.path(varRef.getName()).asText(""));
                    }
                    dispatchCriteria = DispatchCriteriaHelper.extractFromParamMap(dispatcherRules, queryParams);
                    break;
                }
                case "JSON_BODY": {
                    try {
                        JsonEvaluationSpecification specification = JsonEvaluationSpecification.buildFromJsonString(dispatcherRules);
                        dispatchCriteria = JsonExpressionEvaluator.evaluate(this.mapper.writeValueAsString((Object)requestVariables), specification);
                        break;
                    }
                    catch (JsonMappingException jme) {
                        log.error("Dispatching rules of operation cannot be interpreted as JsonEvaluationSpecification", (Throwable)jme);
                        break;
                    }
                    catch (JsonProcessingException jpe) {
                        log.error("Request variables cannot be serialized as Json for evaluation", (Throwable)jpe);
                    }
                }
            }
        }
        return new DispatchContext(dispatchCriteria, requestContext);
    }

    protected void filterFieldSelection(SelectionSet selectionSet, List<FragmentDefinition> fragmentDefinitions, JsonNode node) {
        if (selectionSet == null || selectionSet.getSelections() == null || selectionSet.getSelections().isEmpty()) {
            return;
        }
        switch (node.getNodeType()) {
            case OBJECT: {
                ArrayList<String> properties = new ArrayList<String>();
                for (Selection selection : selectionSet.getSelections()) {
                    if (selection instanceof Field) {
                        Field fieldSelection = (Field)selection;
                        this.filterFieldSelection(fieldSelection.getSelectionSet(), fragmentDefinitions, node.get(fieldSelection.getName()));
                        properties.add(fieldSelection.getName());
                        continue;
                    }
                    if (!(selection instanceof FragmentSpread)) continue;
                    FragmentSpread fragmentSpread = (FragmentSpread)selection;
                    FragmentDefinition fragmentDef = fragmentDefinitions.stream().filter(def -> def.getName().equals(fragmentSpread.getName())).findFirst().orElse(null);
                    if (fragmentDef == null) continue;
                    this.filterFieldSelection(fragmentDef.getSelectionSet(), fragmentDefinitions, node);
                }
                if (properties.isEmpty()) break;
                ((ObjectNode)node).retain(properties);
                break;
            }
            case ARRAY: {
                Iterator children = node.elements();
                while (children.hasNext()) {
                    this.filterFieldSelection(selectionSet, fragmentDefinitions, (JsonNode)children.next());
                }
                break;
            }
        }
    }

    protected class GraphQLQueryResponse {
        String operationName;
        String alias;
        Long operationDelay;
        Response response;
        JsonNode jsonResponse;

        protected GraphQLQueryResponse() {
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Long getOperationDelay() {
            return this.operationDelay;
        }

        public void setOperationDelay(Long operationDelay) {
            this.operationDelay = operationDelay;
        }

        public JsonNode getJsonResponse() {
            return this.jsonResponse;
        }

        public void setJsonResponse(JsonNode jsonResponse) {
            this.jsonResponse = jsonResponse;
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }
    }

    protected static class GraphQLQueryProcessingException
    extends Exception {
        final HttpStatus status;

        public HttpStatus getStatus() {
            return this.status;
        }

        public GraphQLQueryProcessingException(String message, HttpStatus status) {
            super(message);
            this.status = status;
        }
    }
}

