/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.listener;

import io.github.microcks.event.ServiceViewChangeEvent;
import io.github.microcks.listener.ServiceChangeEventChannel;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"default", "prod"})
@ConditionalOnProperty(value={"async-api.enabled"}, havingValue="true", matchIfMissing=true)
public class KafkaServiceChangeEventChannel
implements ServiceChangeEventChannel {
    private final KafkaTemplate<String, ServiceViewChangeEvent> kafkaTemplate;

    public KafkaServiceChangeEventChannel(KafkaTemplate<String, ServiceViewChangeEvent> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    @Override
    public void sendServiceViewChangeEvent(ServiceViewChangeEvent event) throws Exception {
        this.kafkaTemplate.send("microcks-services-updates", (Object)event.getServiceId(), (Object)event);
    }
}

