/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.listener;

import io.github.microcks.domain.Service;
import io.github.microcks.event.ChangeType;
import io.github.microcks.event.ServiceChangeEvent;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.service.MetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class TestConformanceMetricConfigurer
implements ApplicationListener<ServiceChangeEvent> {
    private static Logger log = LoggerFactory.getLogger(TestConformanceMetricConfigurer.class);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private MetricsService metricsService;

    @Async
    public void onApplicationEvent(ServiceChangeEvent event) {
        log.debug("Received a ServiceChangeEvent on " + event.getServiceId());
        if (event.getChangeType().equals((Object)ChangeType.DELETED)) {
            this.metricsService.removeTestConformanceMetric(event.getServiceId());
        } else {
            Service service = this.serviceRepository.findById(event.getServiceId()).orElse(null);
            if (service != null) {
                this.metricsService.configureTestConformanceMetric(service);
            } else {
                log.warn("Service with id {} not found but not a DELETED event?!", (Object)event.getServiceId());
            }
        }
        log.debug("Processing of ServiceChangeEvent done !");
    }
}

