/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import io.github.microcks.security.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class KeycloakTokenToUserInfoMapper {
    private static Logger log = LoggerFactory.getLogger(KeycloakTokenToUserInfoMapper.class);

    public static UserInfo map(SecurityContext context) {
        Authentication authentication = context.getAuthentication();
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtToken = (JwtAuthenticationToken)authentication;
            Jwt jwt = (Jwt)jwtToken.getToken();
            String[] microcksGroups = new String[]{};
            if (jwt.hasClaim("microcks-groups")) {
                microcksGroups = (String[])jwt.getClaimAsStringList("microcks-groups").toArray(String[]::new);
            }
            UserInfo userInfo = new UserInfo(jwt.getClaimAsString("name"), jwt.getClaimAsString("preferred_username"), jwt.getClaimAsString("given_name"), jwt.getClaimAsString("family_name"), jwt.getClaimAsString("email"), (String[])authentication.getAuthorities().stream().map(grantedAuthority -> grantedAuthority.getAuthority().replace("ROLE_", "")).toArray(String[]::new), microcksGroups);
            log.debug("Current user is: {}", (Object)userInfo);
            return userInfo;
        }
        return null;
    }
}

