/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.OAuth2AuthorizedClient;
import io.github.microcks.domain.OAuth2ClientContext;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.TestCaseResult;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.domain.TestRunnerType;
import io.github.microcks.domain.TestStepResult;
import io.github.microcks.event.TestCompletionEvent;
import io.github.microcks.repository.RequestRepository;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.SecretRepository;
import io.github.microcks.repository.TestResultRepository;
import io.github.microcks.security.AuthorizationException;
import io.github.microcks.security.OAuth2AuthorizedClientProvider;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.asyncapi.AsyncAPITestRunner;
import io.github.microcks.util.graphql.GraphQLTestRunner;
import io.github.microcks.util.grpc.GrpcTestRunner;
import io.github.microcks.util.openapi.OpenAPITestRunner;
import io.github.microcks.util.postman.PostmanTestStepsRunner;
import io.github.microcks.util.soapui.SoapUIAssertionsTestRunner;
import io.github.microcks.util.test.AbstractTestRunner;
import io.github.microcks.util.test.HttpTestRunner;
import io.github.microcks.util.test.SoapHttpTestRunner;
import java.io.ByteArrayInputStream;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.scheduling.annotation.Async;

@org.springframework.stereotype.Service
public class TestRunnerService {
    private static final Logger log = LoggerFactory.getLogger(TestRunnerService.class);
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private final ResourceRepository resourceRepository;
    private final RequestRepository requestRepository;
    private final ResponseRepository responseRepository;
    private final TestResultRepository testResultRepository;
    private final SecretRepository secretRepository;
    private final ApplicationContext applicationContext;
    @Value(value="${tests-callback.url}")
    private String testsCallbackUrl = null;
    @Value(value="${postman-runner.url}")
    private String postmanRunnerUrl = null;
    @Value(value="${async-minion.url}")
    private String asyncMinionUrl = null;
    @Value(value="${validation.resourceUrl}")
    private String validationResourceUrl = null;

    public TestRunnerService(ResourceRepository resourceRepository, RequestRepository requestRepository, ResponseRepository responseRepository, TestResultRepository testResultRepository, SecretRepository secretRepository, ApplicationContext applicationContext) {
        this.resourceRepository = resourceRepository;
        this.requestRepository = requestRepository;
        this.responseRepository = responseRepository;
        this.testResultRepository = testResultRepository;
        this.secretRepository = secretRepository;
        this.applicationContext = applicationContext;
    }

    @Async
    public CompletableFuture<TestResult> launchTestsInternal(TestResult testResult, Service service, TestRunnerType runnerType, OAuth2ClientContext oAuth2Context) {
        AbstractTestRunner<HttpMethod> testRunner;
        List<TestResult> older = this.testResultRepository.findByServiceId(service.getId(), (Pageable)PageRequest.of((int)0, (int)2, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"testNumber"}));
        if (older != null && !older.isEmpty() && older.get(0).getTestNumber() != null) {
            testResult.setTestNumber(Long.valueOf(older.get(0).getTestNumber() + 1L));
        } else {
            testResult.setTestNumber(Long.valueOf(1L));
        }
        Secret secret = null;
        if (testResult.getSecretRef() != null) {
            secret = this.secretRepository.findById(testResult.getSecretRef().getSecretId()).orElse(null);
            log.debug("Using a secret to test endpoint? '{}'", (Object)(secret != null ? secret.getName() : "none"));
        }
        if (oAuth2Context != null) {
            log.debug("Applying OAuth2 grant before actually running the test '{}'", (Object)oAuth2Context.getGrantType());
            OAuth2AuthorizedClientProvider tokenProvider = new OAuth2AuthorizedClientProvider();
            try {
                OAuth2AuthorizedClient authorizedClient = tokenProvider.authorize(oAuth2Context);
                testResult.setAuthorizedClient(authorizedClient);
                if (secret != null) {
                    log.debug("Updating the Secret with token from OAuth2 for '{}'", (Object)authorizedClient.getPrincipalName());
                    secret.setToken(authorizedClient.getEncodedAccessToken());
                    secret.setTokenHeader(null);
                } else {
                    secret = new Secret();
                    secret.setToken(authorizedClient.getEncodedAccessToken());
                }
            }
            catch (AuthorizationException authorizationException) {
                log.error("OAuth2 token flow '{}' failed with: {}", (Object)oAuth2Context.getGrantType(), (Object)authorizationException.getMessage());
                log.error("Marking the test as a failure before cancelling it");
                testResult.setSuccess(false);
                testResult.setInProgress(false);
                testResult.setElapsedTime(0L);
                this.testResultRepository.save(testResult);
                return CompletableFuture.completedFuture(testResult);
            }
        }
        if ((testRunner = this.retrieveRunner(runnerType, secret, testResult.getTimeout(), service.getId())) == null) {
            testResult.setSuccess(false);
            testResult.setInProgress(false);
            testResult.setElapsedTime(0L);
            this.testResultRepository.save(testResult);
            return CompletableFuture.completedFuture(testResult);
        }
        for (TestCaseResult testCaseResult : testResult.getTestCaseResults()) {
            Operation operation = service.getOperations().stream().filter(o -> o.getName().equals(testCaseResult.getOperationName())).findFirst().get();
            String testCaseId = IdBuilder.buildTestCaseId((TestResult)testResult, (Operation)operation);
            List<Request> requests = this.requestRepository.findByOperationId(IdBuilder.buildOperationId((Service)service, (Operation)operation));
            requests = this.cloneRequestsForTestCase(requests, testCaseId);
            ArrayList<TestReturn> results = new ArrayList();
            try {
                HttpMethod method = testRunner.buildMethod(operation.getMethod());
                results = testRunner.runTest(service, operation, testResult, requests, testResult.getTestedEndpoint(), method);
            }
            catch (URISyntaxException use) {
                log.error("URISyntaxException on endpoint {}, aborting current tests", (Object)testResult.getTestedEndpoint(), (Object)use);
                testCaseResult.setSuccess(false);
                testCaseResult.setElapsedTime(0L);
                this.testResultRepository.save(testResult);
                break;
            }
            catch (Throwable t) {
                log.error("Throwable while testing operation {}", (Object)operation.getName(), (Object)t);
            }
            if (results == null) {
                testCaseResult.setSuccess(false);
                testCaseResult.setElapsedTime(0L);
                this.testResultRepository.save(testResult);
                continue;
            }
            if (results.isEmpty()) continue;
            this.updateTestCaseResultWithReturns(testCaseResult, results, testCaseId);
            this.testResultRepository.save(testResult);
        }
        this.updateTestResult(testResult);
        return CompletableFuture.completedFuture(testResult);
    }

    private void updateTestCaseResultWithReturns(TestCaseResult testCaseResult, List<TestReturn> testReturns, String testCaseId) {
        boolean successFlag = true;
        long caseElapsedTime = 0L;
        ArrayList<Response> responses = new ArrayList<Response>();
        ArrayList<Request> actualRequests = new ArrayList<Request>();
        for (TestReturn testReturn : testReturns) {
            caseElapsedTime += testReturn.getElapsedTime();
            TestStepResult testStepResult = testReturn.buildTestStepResult();
            if (!testStepResult.isSuccess()) {
                successFlag = false;
            }
            testReturn.getResponse().setTestCaseId(testCaseId);
            testReturn.getRequest().setTestCaseId(testCaseId);
            responses.add(testReturn.getResponse());
            actualRequests.add(testReturn.getRequest());
            testCaseResult.getTestStepResults().add(testStepResult);
        }
        log.debug("Saving {} responses with testCaseId {}", (Object)responses.size(), (Object)testCaseId);
        this.responseRepository.saveAll(responses);
        for (int i = 0; i < actualRequests.size(); ++i) {
            ((Request)actualRequests.get(i)).setResponseId(((Response)responses.get(i)).getId());
        }
        log.debug("Saving {} requests with testCaseId {}", (Object)responses.size(), (Object)testCaseId);
        this.requestRepository.saveAll(actualRequests);
        if (!testCaseResult.getTestStepResults().isEmpty()) {
            testCaseResult.setSuccess(successFlag);
        }
        testCaseResult.setElapsedTime(caseElapsedTime);
    }

    private void updateTestResult(TestResult testResult) {
        log.debug("Updating total testResult");
        boolean globalSuccessFlag = true;
        boolean globalProgressFlag = false;
        long totalElapsedTime = 0L;
        for (TestCaseResult testCaseResult : testResult.getTestCaseResults()) {
            totalElapsedTime += testCaseResult.getElapsedTime();
            if (!testCaseResult.isSuccess()) {
                globalSuccessFlag = false;
            }
            if (testCaseResult.getElapsedTime() != -1L) continue;
            log.debug("testCaseResult.elapsedTime is -1, set globalProgressFlag to true");
            globalProgressFlag = true;
        }
        testResult.setSuccess(globalSuccessFlag);
        testResult.setInProgress(globalProgressFlag);
        testResult.setElapsedTime(totalElapsedTime);
        this.testResultRepository.save(testResult);
        if (!testResult.isInProgress()) {
            this.publishTestCompletionEvent(testResult);
        }
    }

    private List<Request> cloneRequestsForTestCase(List<Request> requests, String testCaseId) {
        ArrayList<Request> result = new ArrayList<Request>();
        for (Request request : requests) {
            Request clone = new Request();
            clone.setName(request.getName());
            clone.setContent(request.getContent());
            clone.setHeaders(request.getHeaders());
            clone.setQueryParameters(request.getQueryParameters());
            clone.setResponseId(request.getResponseId());
            clone.setTestCaseId(testCaseId);
            result.add(clone);
        }
        return result;
    }

    private AbstractTestRunner<HttpMethod> retrieveRunner(TestRunnerType runnerType, Secret secret, Long runnerTimeout, String serviceId) {
        SSLContext sslContext = null;
        try {
            if (secret != null && secret.getCaCertPem() != null) {
                log.debug("Test Secret contains a CA Cert, installing certificate into SSLContext");
                sslContext = SSLContexts.custom().loadTrustMaterial(this.buildCustomCaCertTruststore(secret.getCaCertPem()), null).build();
            } else {
                log.debug("No Test Secret or no CA Cert found, installing accept everything strategy");
                sslContext = SSLContexts.custom().loadTrustMaterial(null, (cert, authType) -> true).build();
            }
        }
        catch (Exception e) {
            log.error("Exception while building SSLContext with acceptingTrustStrategy", (Throwable)e);
            return null;
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2", "TLSv1.3"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)runnerTimeout)).build()).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        factory.setConnectTimeout(200);
        switch (runnerType) {
            case SOAP_HTTP: {
                SoapHttpTestRunner soapRunner = new SoapHttpTestRunner(this.resourceRepository);
                soapRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                soapRunner.setResourceUrl(this.validationResourceUrl);
                soapRunner.setSecret(secret);
                return soapRunner;
            }
            case OPEN_API_SCHEMA: {
                OpenAPITestRunner openApiRunner = new OpenAPITestRunner(this.resourceRepository, this.responseRepository, true);
                openApiRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                openApiRunner.setResourceUrl(this.validationResourceUrl);
                openApiRunner.setSecret(secret);
                return openApiRunner;
            }
            case ASYNC_API_SCHEMA: {
                AsyncAPITestRunner asyncApiRunner = new AsyncAPITestRunner(this.resourceRepository, this.secretRepository);
                asyncApiRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                asyncApiRunner.setAsyncMinionUrl(this.asyncMinionUrl);
                return asyncApiRunner;
            }
            case GRPC_PROTOBUF: {
                GrpcTestRunner grpcRunner = new GrpcTestRunner(this.resourceRepository);
                grpcRunner.setSecret(secret);
                grpcRunner.setTimeout(runnerTimeout);
                return grpcRunner;
            }
            case GRAPHQL_SCHEMA: {
                GraphQLTestRunner graphqlRunner = new GraphQLTestRunner(this.resourceRepository);
                graphqlRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                graphqlRunner.setSecret(secret);
                return graphqlRunner;
            }
            case POSTMAN: {
                PostmanTestStepsRunner postmanRunner = new PostmanTestStepsRunner(this.resourceRepository);
                postmanRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                postmanRunner.setTestsCallbackUrl(this.testsCallbackUrl);
                postmanRunner.setPostmanRunnerUrl(this.postmanRunnerUrl);
                return postmanRunner;
            }
            case SOAP_UI: {
                SoapUIAssertionsTestRunner soapUIRunner = new SoapUIAssertionsTestRunner(this.resourceRepository);
                soapUIRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                soapUIRunner.setResourceUrl(this.validationResourceUrl);
                soapUIRunner.setSecret(secret);
                return soapUIRunner;
            }
        }
        HttpTestRunner httpRunner = new HttpTestRunner();
        httpRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
        httpRunner.setSecret(secret);
        return httpRunner;
    }

    private KeyStore buildCustomCaCertTruststore(String caCertPem) throws Exception {
        String strippedPem = caCertPem.replace(BEGIN_CERTIFICATE, "").replace(END_CERTIFICATE, "");
        ByteArrayInputStream is = new ByteArrayInputStream(Base64.decodeBase64((String)strippedPem));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        ks.setCertificateEntry("caCert", caCert);
        return ks;
    }

    private void publishTestCompletionEvent(TestResult testResult) {
        TestCompletionEvent event = new TestCompletionEvent(this, testResult);
        this.applicationContext.publishEvent((ApplicationEvent)event);
        log.debug("Test completion event has been published");
    }
}

