/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.ParameterConstraint;
import io.github.microcks.domain.ParameterLocation;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.service.ProxyService;
import io.github.microcks.util.AbsoluteUrlMatcher;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.ParameterConstraintUtil;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.JsonEvaluationSpecification;
import io.github.microcks.util.dispatcher.JsonExpressionEvaluator;
import io.github.microcks.util.dispatcher.JsonMappingException;
import io.github.microcks.util.dispatcher.ProxyFallbackSpecification;
import io.github.microcks.util.el.EvaluableRequest;
import io.github.microcks.util.script.ScriptEngineBinder;
import io.github.microcks.web.DispatchContext;
import io.github.microcks.web.MockControllerCommons;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;

@org.springframework.web.bind.annotation.RestController
@RequestMapping(value={"/rest"})
public class RestController {
    private static final Logger log = LoggerFactory.getLogger(RestController.class);
    private final ServiceRepository serviceRepository;
    private final ResponseRepository responseRepository;
    private final ApplicationContext applicationContext;
    private final ProxyService proxyService;
    @Value(value="${mocks.enable-invocation-stats}")
    private final Boolean enableInvocationStats = null;
    @Value(value="${mocks.rest.enable-cors-policy}")
    private final Boolean enableCorsPolicy = null;
    @Value(value="${mocks.rest.cors.allowedOrigins}")
    private String corsAllowedOrigins;
    @Value(value="${mocks.rest.cors.allowCredentials}")
    private Boolean corsAllowCredentials;

    public RestController(ServiceRepository serviceRepository, ResponseRepository responseRepository, ApplicationContext applicationContext, ProxyService proxyService) {
        this.serviceRepository = serviceRepository;
        this.responseRepository = responseRepository;
        this.applicationContext = applicationContext;
        this.proxyService = proxyService;
    }

    @RequestMapping(value={"/{service}/{version}/**"}, method={RequestMethod.HEAD, RequestMethod.OPTIONS, RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public ResponseEntity<byte[]> execute(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @RequestParam(value="delay", required=false) Long delay, @RequestBody(required=false) String body, @RequestHeader HttpHeaders headers, HttpServletRequest request, HttpMethod method) {
        Service service;
        String trimmedResourcePath;
        log.info("Servicing mock response for service [{}, {}] on uri {} with verb {}", new Object[]{serviceName, version, request.getRequestURI(), method});
        log.debug("Request body: {}", (Object)body);
        long startTime = System.currentTimeMillis();
        String serviceAndVersion = MockControllerCommons.composeServiceAndVersion(serviceName, version);
        String resourcePath = MockControllerCommons.extractResourcePath(request, serviceAndVersion);
        log.debug("Found resourcePath: {}", (Object)resourcePath);
        if (serviceName.contains("+")) {
            serviceName = serviceName.replace('+', ' ');
        }
        if ((trimmedResourcePath = resourcePath).endsWith("/")) {
            trimmedResourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        if ((service = this.serviceRepository.findByNameAndVersion(serviceName, version)) == null) {
            return new ResponseEntity((Object)String.format("The service %s with version %s does not exist!", serviceName, version).getBytes(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Operation rOperation = null;
        for (Operation operation : service.getOperations()) {
            if (!operation.getMethod().equals(method.name()) || operation.getResourcePaths() == null || !operation.getResourcePaths().contains(resourcePath) && !operation.getResourcePaths().contains(trimmedResourcePath)) continue;
            rOperation = operation;
            break;
        }
        if (rOperation == null) {
            for (Operation operation : service.getOperations()) {
                if (!operation.getMethod().equals(method.name()) || operation.getResourcePaths() == null) continue;
                String operationPattern = this.getURIPattern(operation.getName());
                operationPattern = operationPattern.replaceAll("\\{[\\w-]+\\}", "([^/])+");
                if (!resourcePath.matches(operationPattern = operationPattern.replaceAll("(/:[^:^/]+)", "\\/([^/]+)"))) continue;
                rOperation = operation;
                break;
            }
        }
        if (rOperation != null) {
            Optional<URI> proxyUrl;
            ProxyFallbackSpecification proxyFallback;
            log.debug("Found a valid operation {} with rules: {}", (Object)rOperation.getName(), (Object)rOperation.getDispatcherRules());
            String violationMsg = this.validateParameterConstraintsIfAny(rOperation, request);
            if (violationMsg != null) {
                return new ResponseEntity((Object)(violationMsg + ". Check parameter constraints.").getBytes(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            String dispatcher = rOperation.getDispatcher();
            String dispatcherRules = rOperation.getDispatcherRules();
            FallbackSpecification fallback = MockControllerCommons.getFallbackIfAny(rOperation);
            if (fallback != null) {
                dispatcher = fallback.getDispatcher();
                dispatcherRules = fallback.getDispatcherRules();
            }
            if ((proxyFallback = MockControllerCommons.getProxyFallbackIfAny(rOperation)) != null) {
                dispatcher = proxyFallback.getDispatcher();
                dispatcherRules = proxyFallback.getDispatcherRules();
            }
            DispatchContext dispatchContext = this.computeDispatchCriteria(dispatcher, dispatcherRules, this.getURIPattern(rOperation.getName()), UriUtils.decode((String)resourcePath, (String)"UTF-8"), request, body);
            log.debug("Dispatch criteria for finding response is {}", (Object)dispatchContext.dispatchCriteria());
            Response response = null;
            List<Response> responses = this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
            response = this.getResponseByMediaType(responses, request);
            if (response == null) {
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
                response = this.getResponseByMediaType(responses, request);
            }
            if (response == null && fallback != null) {
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), fallback.getFallback());
                response = this.getResponseByMediaType(responses, request);
            }
            if ((proxyUrl = MockControllerCommons.getProxyUrlIfProxyIsNeeded(dispatcher, dispatcherRules, resourcePath, proxyFallback, request, response)).isPresent()) {
                return this.proxyService.callExternal(proxyUrl.get(), method, headers, body);
            }
            if (response == null) {
                if (dispatcher == null) {
                    log.debug("No responses found so far, tempting with just bare operationId...");
                    responses = this.responseRepository.findByOperationId(IdBuilder.buildOperationId((Service)service, (Operation)rOperation));
                    if (!responses.isEmpty()) {
                        response = this.getResponseByMediaType(responses, request);
                    }
                } else {
                    return new ResponseEntity((Object)String.format("The response %s does not exist!", dispatchContext.dispatchCriteria()).getBytes(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
                }
            }
            if (response != null) {
                HttpStatus status = response.getStatus() != null ? HttpStatus.valueOf((int)Integer.parseInt(response.getStatus())) : HttpStatus.OK;
                HttpHeaders responseHeaders = new HttpHeaders();
                if (response.getMediaType() != null) {
                    responseHeaders.setContentType(MediaType.valueOf((String)(response.getMediaType() + ";charset=UTF-8")));
                }
                this.recopyHeadersFromParameterConstraints(rOperation, request, responseHeaders);
                if (response.getHeaders() != null) {
                    EvaluableRequest evaluableRequest = MockControllerCommons.buildEvaluableRequest(body, resourcePath, request);
                    Set<Header> renderedHeaders = MockControllerCommons.renderResponseHeaders(evaluableRequest, dispatchContext.requestContext(), response);
                    for (Header renderedHeader : renderedHeaders) {
                        if ("Location".equals(renderedHeader.getName())) {
                            Object location = (String)renderedHeader.getValues().iterator().next();
                            if (!AbsoluteUrlMatcher.matches((String)location)) {
                                location = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/rest" + serviceAndVersion + (String)location;
                            }
                            responseHeaders.add(renderedHeader.getName(), (String)location);
                            continue;
                        }
                        if ("Transfer-Encoding".equalsIgnoreCase(renderedHeader.getName())) continue;
                        responseHeaders.put(renderedHeader.getName(), new ArrayList(renderedHeader.getValues()));
                    }
                }
                String responseContent = MockControllerCommons.renderResponseContent(body, resourcePath, request, dispatchContext.requestContext(), response);
                if (delay == null && rOperation.getDefaultDelay() != null) {
                    delay = rOperation.getDefaultDelay();
                }
                MockControllerCommons.waitForDelay(startTime, delay);
                if (this.enableInvocationStats.booleanValue()) {
                    MockControllerCommons.publishMockInvocation(this.applicationContext, this, service, response, startTime);
                }
                if (responseContent != null) {
                    return new ResponseEntity((Object)responseContent.getBytes(), (MultiValueMap)responseHeaders, (HttpStatusCode)status);
                }
                return new ResponseEntity((MultiValueMap)responseHeaders, (HttpStatusCode)status);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (this.enableCorsPolicy.booleanValue() && HttpMethod.OPTIONS.equals((Object)method)) {
            log.debug("No valid operation found but Microcks configured to apply CORS policy");
            return this.handleCorsRequest(request);
        }
        log.debug("No valid operation found and Microcks configured to not apply CORS policy...");
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private String validateParameterConstraintsIfAny(Operation rOperation, HttpServletRequest request) {
        if (rOperation.getParameterConstraints() != null) {
            for (ParameterConstraint constraint : rOperation.getParameterConstraints()) {
                String violationMsg = ParameterConstraintUtil.validateConstraint(request, constraint);
                if (violationMsg == null) continue;
                return violationMsg;
            }
        }
        return null;
    }

    private DispatchContext computeDispatchCriteria(String dispatcher, String dispatcherRules, String uriPattern, String resourcePath, HttpServletRequest request, String body) {
        Object dispatchCriteria = null;
        HashMap<String, Object> requestContext = null;
        if (dispatcher != null) {
            switch (dispatcher) {
                case "SEQUENCE": {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(dispatcherRules, uriPattern, resourcePath);
                    break;
                }
                case "SCRIPT": {
                    ScriptEngineManager sem = new ScriptEngineManager();
                    requestContext = new HashMap<String, Object>();
                    try {
                        ScriptEngine se = sem.getEngineByExtension("groovy");
                        ScriptEngineBinder.bindEnvironment(se, body, requestContext, request);
                        String script = ScriptEngineBinder.ensureSoapUICompatibility(dispatcherRules);
                        dispatchCriteria = (String)se.eval(script);
                    }
                    catch (Exception e) {
                        log.error("Error during Script evaluation", (Throwable)e);
                    }
                    break;
                }
                case "URI_PARAMS": {
                    String fullURI = request.getRequestURL() + "?" + request.getQueryString();
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIParams(dispatcherRules, fullURI);
                    break;
                }
                case "URI_PARTS": {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(dispatcherRules, uriPattern, resourcePath);
                    break;
                }
                case "URI_ELEMENTS": {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(dispatcherRules, uriPattern, resourcePath);
                    String fullURI = request.getRequestURL() + "?" + request.getQueryString();
                    dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.extractFromURIParams(dispatcherRules, fullURI);
                    break;
                }
                case "JSON_BODY": {
                    try {
                        JsonEvaluationSpecification specification = JsonEvaluationSpecification.buildFromJsonString(dispatcherRules);
                        dispatchCriteria = JsonExpressionEvaluator.evaluate(body, specification);
                        break;
                    }
                    catch (JsonMappingException jme) {
                        log.error("Dispatching rules of operation cannot be interpreted as JsonEvaluationSpecification", (Throwable)jme);
                    }
                }
            }
        }
        return new DispatchContext((String)dispatchCriteria, (Map<String, Object>)requestContext);
    }

    private void recopyHeadersFromParameterConstraints(Operation rOperation, HttpServletRequest request, HttpHeaders responseHeaders) {
        if (rOperation.getParameterConstraints() != null) {
            for (ParameterConstraint constraint : rOperation.getParameterConstraints()) {
                String value;
                if (ParameterLocation.header != constraint.getIn() || !constraint.isRecopy() || (value = request.getHeader(constraint.getName())) == null) continue;
                responseHeaders.set(constraint.getName(), value);
            }
        }
    }

    private Response getResponseByMediaType(List<Response> responses, HttpServletRequest request) {
        if (!responses.isEmpty()) {
            String accept = request.getHeader("Accept");
            return responses.stream().filter(r -> !StringUtils.isNotEmpty((CharSequence)accept) || accept.equals(r.getMediaType())).findFirst().orElse(responses.get(0));
        }
        return null;
    }

    private String getURIPattern(String operationName) {
        if (operationName.startsWith("GET ") || operationName.startsWith("POST ") || operationName.startsWith("PUT ") || operationName.startsWith("DELETE ") || operationName.startsWith("PATCH ") || operationName.startsWith("OPTIONS ")) {
            return operationName.substring(operationName.indexOf(32) + 1);
        }
        return operationName;
    }

    private ResponseEntity<byte[]> handleCorsRequest(HttpServletRequest request) {
        ArrayList accessControlHeaders = new ArrayList();
        Collections.list(request.getHeaders("Access-Control-Request-Headers")).forEach(header -> accessControlHeaders.add(header));
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setAccessControlAllowHeaders(accessControlHeaders);
        requestHeaders.setAccessControlExposeHeaders(accessControlHeaders);
        return ResponseEntity.noContent().header("Access-Control-Allow-Origin", new String[]{this.corsAllowedOrigins}).header("Access-Control-Allow-Methods", new String[]{"POST, PUT, GET, OPTIONS, DELETE, PATCH"}).headers(requestHeaders).header("Access-Allow-Credentials", new String[]{String.valueOf(this.corsAllowCredentials)}).header("Access-Control-Max-Age", new String[]{"3600"}).header("Vary", new String[]{"Accept-Encoding, Origin"}).build();
    }
}

