/*
 * Decompiled with CFR 0.152.
 */
package io.github.mngsk.devicedetector.device;

import java.util.Optional;

public class Device {
    private final String type;
    private final String brand;
    private final String model;

    public Device(String type, String brand, String model) {
        this.type = type;
        this.brand = brand;
        this.model = model;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getBrand() {
        return Optional.ofNullable(this.brand);
    }

    public Optional<String> getModel() {
        return Optional.ofNullable(this.model);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.brand == null ? 0 : this.brand.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        if (this.brand == null ? other.brand != null : !this.brand.equals(other.brand)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        if (this.brand == null) {
            return this.type;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.brand);
        if (this.model != null) {
            builder.append(" ").append(this.model);
        }
        return builder.toString();
    }
}

