/*
 * Decompiled with CFR 0.152.
 */
package io.github.mngsk.devicedetector.operatingsystem;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.mngsk.devicedetector.operatingsystem.OperatingSystem;
import io.github.mngsk.devicedetector.operatingsystem.OperatingSystemRegex;
import io.github.mngsk.devicedetector.operatingsystem.PlatformRegex;
import io.github.mngsk.devicedetector.util.AbstractParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;

public class OperatingSystemParser
extends AbstractParser<OperatingSystem> {
    private List<OperatingSystemRegex> operatingSystems;
    private Map<String, List<String>> families;
    private List<PlatformRegex> platforms;

    public OperatingSystemParser() {
        this(new ObjectMapper((JsonFactory)new YAMLFactory()));
    }

    public OperatingSystemParser(ObjectMapper objectMapper) {
        String fixtureFile = "regexes/oss.yml";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fixtureFile);
        CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, OperatingSystemRegex.class);
        try {
            this.operatingSystems = (List)objectMapper.readValue(inputStream, (JavaType)listType);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + fixtureFile, e);
        }
        fixtureFile = "regexes/ossfamilies.yml";
        inputStream = this.getClass().getClassLoader().getResourceAsStream(fixtureFile);
        TypeReference<Map<String, List<String>>> mapType = new TypeReference<Map<String, List<String>>>(){};
        try {
            this.families = (Map)objectMapper.readValue(inputStream, (TypeReference)mapType);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + fixtureFile, e);
        }
        fixtureFile = "regexes/ossplatforms.yml";
        inputStream = this.getClass().getClassLoader().getResourceAsStream(fixtureFile);
        listType = objectMapper.getTypeFactory().constructCollectionType(List.class, PlatformRegex.class);
        try {
            this.platforms = (List)objectMapper.readValue(inputStream, (JavaType)listType);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + fixtureFile, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<OperatingSystem> parse(String userAgent) {
        void var5_9;
        String name = null;
        String version = null;
        for (OperatingSystemRegex operatingSystemRegex : this.operatingSystems) {
            Matcher matcher = operatingSystemRegex.getPattern().matcher(userAgent);
            if (!matcher.find()) continue;
            name = super.buildByMatch(operatingSystemRegex.getName(), matcher);
            version = super.buildVersion(operatingSystemRegex.getVersion().orElse(null), matcher);
            break;
        }
        if (name == null) {
            return Optional.empty();
        }
        if (name.equals("lubuntu")) {
            name = "Lubuntu";
        } else if (name.equals("debian")) {
            name = "Debian";
        } else if (name.equals("YunOS")) {
            name = "YunOs";
        }
        String family = null;
        for (Map.Entry<String, List<String>> entry : this.families.entrySet()) {
            if (!entry.getValue().contains(name)) continue;
            family = entry.getKey();
            break;
        }
        Object var5_7 = null;
        for (PlatformRegex p : this.platforms) {
            Matcher matcher = p.getPattern().matcher(userAgent);
            if (!matcher.find()) continue;
            String string = p.getName();
            break;
        }
        return Optional.of(new OperatingSystem(name, family, (String)var5_9, version));
    }
}

