/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxrs;

import feign.Contract;
import feign.MethodMetadata;
import feign.Request;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

public class JAXRSContract
extends Contract.BaseContract {
    static final String ACCEPT = "Accept";
    static final String CONTENT_TYPE = "Content-Type";

    protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        return super.parseAndValidateMetadata(targetType, method);
    }

    protected void processAnnotationOnClass(MethodMetadata data, Class<?> clz) {
        Produces produces;
        Consumes consumes;
        Path path = clz.getAnnotation(Path.class);
        if (path != null && !path.value().isEmpty()) {
            String pathValue = path.value();
            if (!pathValue.startsWith("/")) {
                pathValue = "/" + pathValue;
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            pathValue = pathValue.replaceAll("\\{\\s*(.+?)\\s*(:.+?)?\\}", "\\{$1\\}");
            data.template().uri(pathValue);
        }
        if ((consumes = clz.getAnnotation(Consumes.class)) != null) {
            this.handleConsumesAnnotation(data, consumes, clz.getName());
        }
        if ((produces = clz.getAnnotation(Produces.class)) != null) {
            this.handleProducesAnnotation(data, produces, clz.getName());
        }
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
        HttpMethod http = annotationType.getAnnotation(HttpMethod.class);
        if (http != null) {
            Util.checkState((data.template().method() == null ? 1 : 0) != 0, (String)"Method %s contains multiple HTTP methods. Found: %s and %s", (Object[])new Object[]{method.getName(), data.template().method(), http.value()});
            data.template().method(Request.HttpMethod.valueOf((String)http.value()));
        } else if (annotationType == Path.class) {
            String pathValue = Util.emptyToNull((String)((Path)Path.class.cast(methodAnnotation)).value());
            if (pathValue == null) {
                return;
            }
            String methodAnnotationValue = ((Path)Path.class.cast(methodAnnotation)).value();
            if (!methodAnnotationValue.startsWith("/") && !data.template().url().endsWith("/")) {
                methodAnnotationValue = "/" + methodAnnotationValue;
            }
            methodAnnotationValue = methodAnnotationValue.replaceAll("\\{\\s*(.+?)\\s*(:.+?)?\\}", "\\{$1\\}");
            data.template().uri(methodAnnotationValue, true);
        } else if (annotationType == Produces.class) {
            this.handleProducesAnnotation(data, (Produces)methodAnnotation, "method " + method.getName());
        } else if (annotationType == Consumes.class) {
            this.handleConsumesAnnotation(data, (Consumes)methodAnnotation, "method " + method.getName());
        }
    }

    private void handleProducesAnnotation(MethodMetadata data, Produces produces, String name) {
        String[] serverProduces = (String[])Util.removeValues((Object[])produces.value(), mediaType -> Util.emptyToNull((String)mediaType) == null, String.class);
        Util.checkState((serverProduces.length > 0 ? 1 : 0) != 0, (String)"Produces.value() was empty on %s", (Object[])new Object[]{name});
        data.template().header(ACCEPT, Collections.emptyList());
        data.template().header(ACCEPT, serverProduces);
    }

    private void handleConsumesAnnotation(MethodMetadata data, Consumes consumes, String name) {
        String[] serverConsumes = (String[])Util.removeValues((Object[])consumes.value(), mediaType -> Util.emptyToNull((String)mediaType) == null, String.class);
        Util.checkState((serverConsumes.length > 0 ? 1 : 0) != 0, (String)"Consumes.value() was empty on %s", (Object[])new Object[]{name});
        data.template().header(CONTENT_TYPE, Collections.emptyList());
        data.template().header(CONTENT_TYPE, new String[]{serverConsumes[0]});
    }

    protected boolean isUnsupportedHttpParameterAnnotation(Annotation parameterAnnotation) {
        return false;
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        boolean isHttpParam = false;
        for (Annotation parameterAnnotation : annotations) {
            String name;
            Class<? extends Annotation> annotationType = parameterAnnotation.annotationType();
            if (this.isUnsupportedHttpParameterAnnotation(parameterAnnotation)) {
                isHttpParam = true;
                continue;
            }
            if (annotationType == PathParam.class) {
                name = ((PathParam)PathParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                this.nameParam(data, name, paramIndex);
                isHttpParam = true;
                continue;
            }
            if (annotationType == QueryParam.class) {
                name = ((QueryParam)QueryParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"QueryParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                String query = this.addTemplatedParam(name);
                data.template().query(name, new String[]{query});
                this.nameParam(data, name, paramIndex);
                isHttpParam = true;
                continue;
            }
            if (annotationType == HeaderParam.class) {
                name = ((HeaderParam)HeaderParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"HeaderParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                String header = this.addTemplatedParam(name);
                data.template().header(name, new String[]{header});
                this.nameParam(data, name, paramIndex);
                isHttpParam = true;
                continue;
            }
            if (annotationType != FormParam.class) continue;
            name = ((FormParam)FormParam.class.cast(parameterAnnotation)).value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"FormParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            data.formParams().add(name);
            this.nameParam(data, name, paramIndex);
            isHttpParam = true;
        }
        return isHttpParam;
    }

    private String addTemplatedParam(String name) {
        return String.format("{%s}", name);
    }
}

