/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ChannelLogger;
import io.grpc.Grpc;
import io.grpc.InternalChannelz;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.JettyTlsUtil;
import io.grpc.netty.shaded.io.grpc.netty.NettyClientTransport;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.Utils;
import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.grpc.netty.shaded.io.netty.handler.proxy.HttpProxyHandler;
import io.grpc.netty.shaded.io.netty.handler.proxy.ProxyConnectionEvent;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslEngine;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.Attribute;
import io.grpc.netty.shaded.io.netty.util.AttributeMap;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

final class ProtocolNegotiators {
    private static final Logger log = Logger.getLogger(ProtocolNegotiators.class.getName());

    private ProtocolNegotiators() {
    }

    static ChannelLogger negotiationLogger(ChannelHandlerContext ctx) {
        return ProtocolNegotiators.negotiationLogger(ctx.channel());
    }

    private static ChannelLogger negotiationLogger(AttributeMap attributeMap) {
        Attribute<ChannelLogger> attr = attributeMap.attr(NettyClientTransport.LOGGER_KEY);
        ChannelLogger channelLogger = attr.get();
        if (channelLogger != null) {
            return channelLogger;
        }
        final class NoopChannelLogger
        extends ChannelLogger {
            NoopChannelLogger() {
            }

            public void log(ChannelLogger.ChannelLogLevel level, String message) {
            }

            public void log(ChannelLogger.ChannelLogLevel level, String messageFormat, Object ... args) {
            }
        }
        return new NoopChannelLogger();
    }

    public static ProtocolNegotiator serverPlaintext() {
        return new ProtocolNegotiator(){

            @Override
            public ChannelHandler newHandler(final GrpcHttp2ConnectionHandler handler) {
                class PlaintextHandler
                extends ChannelHandlerAdapter {
                    PlaintextHandler() {
                    }

                    @Override
                    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                        handler.handleProtocolNegotiationCompleted(Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).build(), null);
                        ctx.pipeline().replace(this, null, (ChannelHandler)handler);
                    }
                }
                return new PlaintextHandler();
            }

            @Override
            public void close() {
            }

            @Override
            public AsciiString scheme() {
                return Utils.HTTP;
            }
        };
    }

    public static ProtocolNegotiator serverTls(final SslContext sslContext) {
        Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        return new ProtocolNegotiator(){

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler handler) {
                return new ServerTlsHandler(sslContext, handler);
            }

            @Override
            public void close() {
            }

            @Override
            public AsciiString scheme() {
                return Utils.HTTPS;
            }
        };
    }

    public static ProtocolNegotiator httpProxy(final SocketAddress proxyAddress, final @Nullable String proxyUsername, final @Nullable String proxyPassword, final ProtocolNegotiator negotiator) {
        Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        Preconditions.checkNotNull((Object)proxyAddress, (Object)"proxyAddress");
        final AsciiString scheme = negotiator.scheme();
        class ProxyNegotiator
        implements ProtocolNegotiator {
            ProxyNegotiator() {
            }

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler http2Handler) {
                ChannelHandler protocolNegotiationHandler = negotiator.newHandler(http2Handler);
                ProxyProtocolNegotiationHandler ppnh = new ProxyProtocolNegotiationHandler(proxyAddress, proxyUsername, proxyPassword, protocolNegotiationHandler);
                return ppnh;
            }

            @Override
            public AsciiString scheme() {
                return scheme;
            }

            @Override
            public void close() {
                negotiator.close();
            }
        }
        return new ProxyNegotiator();
    }

    @VisibleForTesting
    static HostPort parseAuthority(String authority) {
        int port;
        String host;
        URI uri = GrpcUtil.authorityToUri((String)((String)Preconditions.checkNotNull((Object)authority, (Object)"authority")));
        if (uri.getHost() != null) {
            host = uri.getHost();
            port = uri.getPort();
        } else {
            host = authority;
            port = -1;
        }
        return new HostPort(host, port);
    }

    public static ProtocolNegotiator tls(SslContext sslContext) {
        return new ClientTlsProtocolNegotiator(sslContext);
    }

    public static ProtocolNegotiator plaintextUpgrade() {
        return new PlaintextUpgradeProtocolNegotiator();
    }

    public static ProtocolNegotiator plaintext() {
        return new PlaintextProtocolNegotiator();
    }

    private static RuntimeException unavailableException(String msg) {
        return Status.UNAVAILABLE.withDescription(msg).asRuntimeException();
    }

    @VisibleForTesting
    static void logSslEngineDetails(Level level, ChannelHandlerContext ctx, String msg, @Nullable Throwable t) {
        if (!log.isLoggable(level)) {
            return;
        }
        SslHandler sslHandler = ctx.pipeline().get(SslHandler.class);
        SSLEngine engine = sslHandler.engine();
        StringBuilder builder = new StringBuilder(msg);
        builder.append("\nSSLEngine Details: [\n");
        if (engine instanceof OpenSslEngine) {
            builder.append("    OpenSSL, ");
            builder.append("Version: 0x").append(Integer.toHexString(OpenSsl.version()));
            builder.append(" (").append(OpenSsl.versionString()).append("), ");
            builder.append("ALPN supported: ").append(OpenSsl.isAlpnSupported());
        } else if (JettyTlsUtil.isJettyAlpnConfigured()) {
            builder.append("    Jetty ALPN");
        } else if (JettyTlsUtil.isJettyNpnConfigured()) {
            builder.append("    Jetty NPN");
        } else if (JettyTlsUtil.isJava9AlpnAvailable()) {
            builder.append("    JDK9 ALPN");
        }
        builder.append("\n    TLS Protocol: ");
        builder.append(engine.getSession().getProtocol());
        builder.append("\n    Application Protocol: ");
        builder.append(sslHandler.applicationProtocol());
        builder.append("\n    Need Client Auth: ");
        builder.append(engine.getNeedClientAuth());
        builder.append("\n    Want Client Auth: ");
        builder.append(engine.getWantClientAuth());
        builder.append("\n    Supported protocols=");
        builder.append(Arrays.toString(engine.getSupportedProtocols()));
        builder.append("\n    Enabled protocols=");
        builder.append(Arrays.toString(engine.getEnabledProtocols()));
        builder.append("\n    Supported ciphers=");
        builder.append(Arrays.toString(engine.getSupportedCipherSuites()));
        builder.append("\n    Enabled ciphers=");
        builder.append(Arrays.toString(engine.getEnabledCipherSuites()));
        builder.append("\n]");
        log.log(level, builder.toString(), t);
    }

    static final class WaitUntilActiveHandler
    extends ChannelInboundHandlerAdapter {
        private final ChannelHandler next;
        private ProtocolNegotiationEvent pne;

        public WaitUntilActiveHandler(ChannelHandler next) {
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "WaitUntilActive started");
            super.handlerAdded(ctx);
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            if (this.pne != null) {
                this.fireProtocolNegotiationEvent(ctx);
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                Preconditions.checkState((this.pne == null ? 1 : 0) != 0, (Object)"negotiation already started");
                this.pne = (ProtocolNegotiationEvent)evt;
                if (ctx.channel().isActive()) {
                    this.fireProtocolNegotiationEvent(ctx);
                }
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx) {
            Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"negotiation not yet complete");
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "WaitUntilActive finished");
            ctx.pipeline().replace(ctx.name(), null, this.next);
            Attributes attrs = this.pne.getAttributes().toBuilder().set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.NONE).build();
            ctx.fireUserEventTriggered(this.pne.withAttributes(attrs));
        }
    }

    static final class PlaintextProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextProtocolNegotiator() {
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            GrpcNegotiationHandler grpcNegotiationHandler = new GrpcNegotiationHandler(grpcHandler);
            WaitUntilActiveHandler activeHandler = new WaitUntilActiveHandler(grpcNegotiationHandler);
            return activeHandler;
        }

        @Override
        public void close() {
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTP;
        }
    }

    static final class GrpcNegotiationHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler next;

        public GrpcNegotiationHandler(GrpcHttp2ConnectionHandler next) {
            this.next = (GrpcHttp2ConnectionHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                ProtocolNegotiationEvent protocolNegotiationEvent = (ProtocolNegotiationEvent)evt;
                ctx.pipeline().replace(ctx.name(), null, (ChannelHandler)this.next);
                this.next.handleProtocolNegotiationCompleted(protocolNegotiationEvent.getAttributes(), protocolNegotiationEvent.getSecurity());
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    static final class Http2UpgradeAndGrpcHandler
    extends ChannelInboundHandlerAdapter {
        private final String authority;
        private final GrpcHttp2ConnectionHandler next;
        private ProtocolNegotiationEvent pne;

        Http2UpgradeAndGrpcHandler(String authority, GrpcHttp2ConnectionHandler next) {
            this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
            this.next = (GrpcHttp2ConnectionHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "Http2Upgrade started");
            HttpClientCodec httpClientCodec = new HttpClientCodec();
            ctx.pipeline().addBefore(ctx.name(), null, httpClientCodec);
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(this.next);
            HttpClientUpgradeHandler upgrader = new HttpClientUpgradeHandler(httpClientCodec, upgradeCodec, 1000);
            ctx.pipeline().addBefore(ctx.name(), null, upgrader);
            DefaultHttpRequest upgradeTrigger = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            upgradeTrigger.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.authority);
            ctx.writeAndFlush(upgradeTrigger).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            super.handlerAdded(ctx);
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                Preconditions.checkState((this.pne == null ? 1 : 0) != 0, (Object)"negotiation already started");
                this.pne = (ProtocolNegotiationEvent)evt;
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"negotiation not yet complete");
                ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "Http2Upgrade finished");
                ctx.pipeline().remove(ctx.name());
                this.next.handleProtocolNegotiationCompleted(this.pne.getAttributes(), this.pne.getSecurity());
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                ctx.fireExceptionCaught(ProtocolNegotiators.unavailableException("HTTP/2 upgrade rejected"));
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    static final class PlaintextUpgradeProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextUpgradeProtocolNegotiator() {
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTP;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            Http2UpgradeAndGrpcHandler upgradeHandler = new Http2UpgradeAndGrpcHandler(grpcHandler.getAuthority(), grpcHandler);
            WaitUntilActiveHandler wuah = new WaitUntilActiveHandler(upgradeHandler);
            return wuah;
        }

        @Override
        public void close() {
        }
    }

    @VisibleForTesting
    static final class HostPort {
        final String host;
        final int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    static final class ClientTlsHandler
    extends ChannelDuplexHandler {
        private final ChannelHandler next;
        private final SslContext sslContext;
        private final String host;
        private final int port;
        private ProtocolNegotiationEvent pne;

        ClientTlsHandler(ChannelHandler next, SslContext sslContext, String authority) {
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
            HostPort hostPort = ProtocolNegotiators.parseAuthority(authority);
            this.host = hostPort.host;
            this.port = hostPort.port;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "ClientTls started");
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc(), this.host, this.port);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
            ctx.pipeline().addBefore(ctx.name(), null, new SslHandler(sslEngine, false));
            super.handlerAdded(ctx);
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                Preconditions.checkState((this.pne == null ? 1 : 0) != 0, (Object)"negotiation already started");
                this.pne = (ProtocolNegotiationEvent)evt;
            } else if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    SslHandler handler = ctx.pipeline().get(SslHandler.class);
                    if (GrpcSslContexts.NEXT_PROTOCOL_VERSIONS.contains(handler.applicationProtocol())) {
                        ProtocolNegotiators.logSslEngineDetails(Level.FINER, ctx, "TLS negotiation succeeded.", null);
                        ctx.pipeline().replace(ctx.name(), null, this.next);
                        this.fireProtocolNegotiationEvent(ctx, handler.engine().getSession());
                    } else {
                        RuntimeException ex = ProtocolNegotiators.unavailableException("Failed ALPN negotiation: Unable to find compatible protocol");
                        ProtocolNegotiators.logSslEngineDetails(Level.FINE, ctx, "TLS negotiation failed.", ex);
                        ctx.fireExceptionCaught(ex);
                    }
                } else {
                    ctx.fireExceptionCaught(handshakeEvent.cause());
                }
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx, SSLSession session) {
            Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"negotiation not yet complete");
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "ClientTls finished");
            InternalChannelz.Security security = new InternalChannelz.Security(new InternalChannelz.Tls(session));
            Attributes attrs = this.pne.getAttributes().toBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)session).build();
            ctx.fireUserEventTriggered(this.pne.withAttributes(attrs).withSecurity(security));
        }
    }

    static final class ClientTlsProtocolNegotiator
    implements ProtocolNegotiator {
        private final SslContext sslContext;

        public ClientTlsProtocolNegotiator(SslContext sslContext) {
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTPS;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            GrpcNegotiationHandler gnh = new GrpcNegotiationHandler(grpcHandler);
            ClientTlsHandler cth = new ClientTlsHandler(gnh, this.sslContext, grpcHandler.getAuthority());
            WaitUntilActiveHandler wuah = new WaitUntilActiveHandler(cth);
            return wuah;
        }

        @Override
        public void close() {
        }
    }

    static final class ProxyProtocolNegotiationHandler
    extends ChannelDuplexHandler {
        private final SocketAddress address;
        @Nullable
        private final String userName;
        @Nullable
        private final String password;
        private final ChannelHandler next;
        private ProtocolNegotiationEvent pne;

        public ProxyProtocolNegotiationHandler(SocketAddress address, @Nullable String userName, @Nullable String password, ChannelHandler next) {
            this.address = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.userName = userName;
            this.password = password;
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                Preconditions.checkState((this.pne == null ? 1 : 0) != 0, (String)"pre-existing negotiation: %s < %s", (Object)this.pne, (Object)evt);
                this.pne = (ProtocolNegotiationEvent)evt;
                this.protocolNegotiationEventTriggered(ctx);
            } else if (evt instanceof ProxyConnectionEvent) {
                this.fireProtocolNegotiationEvent(ctx);
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private void protocolNegotiationEventTriggered(ChannelHandlerContext ctx) {
            HttpProxyHandler nettyProxyHandler = this.userName == null || this.password == null ? new HttpProxyHandler(this.address) : new HttpProxyHandler(this.address, this.userName, this.password);
            ctx.pipeline().addBefore(ctx.name(), null, nettyProxyHandler);
        }

        private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx) {
            Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"previous protocol negotiation event hasn't triggered");
            ctx.pipeline().replace(ctx.name(), null, this.next);
            ctx.fireUserEventTriggered(this.pne);
        }
    }

    @VisibleForTesting
    static final class ServerTlsHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final SslContext sslContext;

        ServerTlsHandler(SslContext sslContext, GrpcHttp2ConnectionHandler grpcHandler) {
            this.sslContext = sslContext;
            this.grpcHandler = grpcHandler;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc());
            ctx.pipeline().addFirst(new SslHandler(sslEngine, false));
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.fail(ctx, cause);
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    if (GrpcSslContexts.NEXT_PROTOCOL_VERSIONS.contains(this.sslHandler(ctx.pipeline()).applicationProtocol())) {
                        SSLSession session = this.sslHandler(ctx.pipeline()).engine().getSession();
                        this.grpcHandler.handleProtocolNegotiationCompleted(Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)session).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).build(), new InternalChannelz.Security(new InternalChannelz.Tls(session)));
                        ctx.pipeline().replace(this, null, (ChannelHandler)this.grpcHandler);
                    } else {
                        this.fail(ctx, ProtocolNegotiators.unavailableException("Failed protocol negotiation: Unable to find compatible protocol"));
                    }
                } else {
                    this.fail(ctx, handshakeEvent.cause());
                }
            }
            super.userEventTriggered(ctx, evt);
        }

        private SslHandler sslHandler(ChannelPipeline pipeline) {
            return pipeline.get(SslHandler.class);
        }

        private void fail(ChannelHandlerContext ctx, Throwable exception) {
            ProtocolNegotiators.logSslEngineDetails(Level.FINE, ctx, "TLS negotiation failed for new client.", exception);
            ctx.close();
        }
    }
}

