/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.common.metrics.MetricsPublisher;
import java.util.Map;
import java.util.Properties;
import org.skife.config.Coercer;
import org.skife.config.Coercible;

public class MetricsCoercer
implements Coercible<MetricsPublisher> {
    private Properties props;

    public MetricsCoercer(Properties props) {
        this.props = props;
    }

    public Coercer<MetricsPublisher> accept(Class<?> clazz) {
        if (MetricsPublisher.class.isAssignableFrom(clazz)) {
            return new Coercer<MetricsPublisher>(){

                public MetricsPublisher coerce(String className) {
                    try {
                        Properties publishProperties = new Properties();
                        String configPrefix = (String)MetricsCoercer.this.props.get("mantis.metricsPublisher.config.prefix");
                        if (configPrefix != null && configPrefix.length() > 0) {
                            for (Map.Entry<Object, Object> entry : MetricsCoercer.this.props.entrySet()) {
                                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(configPrefix)) continue;
                                publishProperties.put(entry.getKey(), entry.getValue());
                            }
                        }
                        return (MetricsPublisher)Class.forName(className).getConstructor(Properties.class).newInstance(publishProperties);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("The value %s is not a valid class name for %s implementation. ", className, MetricsPublisher.class.getName()), e);
                    }
                }
            };
        }
        return null;
    }
}

