/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.server.core.stats.SimpleStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;
import rx.functions.Action1;
import rx.observers.SerializedObserver;
import rx.subjects.PublishSubject;

public class WorkerOutlier {
    private static final Logger logger = LoggerFactory.getLogger(WorkerOutlier.class);
    private final PublishSubject<DataPoint> subject = PublishSubject.create();
    private final Observer<DataPoint> observer = new SerializedObserver(this.subject);
    private final long cooldownSecs;
    private final Action1<Integer> outlierTrigger;
    private long lastTriggeredAt = 0L;
    private long minDataPoints = 16L;
    private long maxDataPoints = 20L;

    public WorkerOutlier(long cooldownSecs, Action1<Integer> outlierTrigger) {
        this.cooldownSecs = cooldownSecs;
        if (outlierTrigger == null) {
            throw new NullPointerException("outlierTrigger is null");
        }
        this.outlierTrigger = outlierTrigger;
        this.start();
    }

    private void start() {
        logger.info("Starting Worker outlier detector");
        final HashMap values = new HashMap();
        final HashMap isOutlierMap = new HashMap();
        this.subject.doOnNext((Action1)new Action1<DataPoint>(){

            public void call(DataPoint dataPoint) {
                values.put(dataPoint.index, dataPoint.value);
                int currSize = values.size();
                if (currSize > dataPoint.numWorkers) {
                    for (int i = dataPoint.numWorkers; i < currSize; ++i) {
                        values.remove(i);
                        isOutlierMap.remove(i);
                    }
                }
                SimpleStats simpleStats = new SimpleStats(values.values());
                ArrayList<Boolean> booleans = (ArrayList<Boolean>)isOutlierMap.get(dataPoint.index);
                if (booleans == null) {
                    booleans = new ArrayList<Boolean>();
                    isOutlierMap.put(dataPoint.index, booleans);
                }
                if ((long)booleans.size() >= WorkerOutlier.this.maxDataPoints) {
                    booleans.remove(0);
                }
                booleans.add(dataPoint.value > simpleStats.getOutlierThreshold());
                if (System.currentTimeMillis() - WorkerOutlier.this.lastTriggeredAt > WorkerOutlier.this.cooldownSecs * 1000L && (long)booleans.size() > WorkerOutlier.this.minDataPoints) {
                    int total = 0;
                    int outlierCnt = 0;
                    Iterator iterator = booleans.iterator();
                    while (iterator.hasNext()) {
                        boolean b = (Boolean)iterator.next();
                        ++total;
                        if (!b) continue;
                        ++outlierCnt;
                    }
                    if ((long)outlierCnt > Math.round((double)total * 0.7)) {
                        WorkerOutlier.this.outlierTrigger.call((Object)dataPoint.index);
                        WorkerOutlier.this.lastTriggeredAt = System.currentTimeMillis();
                        booleans.clear();
                    }
                }
            }
        }).subscribe();
    }

    public void addDataPoint(int workerIndex, double value, int numWorkers) {
        this.observer.onNext((Object)new DataPoint(workerIndex, value, numWorkers));
    }

    public void completed() {
        this.observer.onCompleted();
    }

    private static class DataPoint {
        private final int index;
        private final double value;
        private final int numWorkers;

        private DataPoint(int index, double value, int numWorkers) {
            this.index = index;
            this.value = value;
            this.numWorkers = numWorkers;
        }
    }
}

