/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.jersey2.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.jersey2.server.AnnotationFinder;
import io.micrometer.jersey2.server.DefaultJerseyTagsProvider;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import io.micrometer.jersey2.server.MetricsApplicationEventListener;
import io.micrometer.spring.autoconfigure.jersey2.server.JerseyServerMetricsProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;

@Configuration
@ConditionalOnClass(value={MetricsApplicationEventListener.class})
@ConditionalOnProperty(value={"management.metrics.jersey2.server.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={JerseyServerMetricsProperties.class})
public class JerseyServerMetricsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={JerseyTagsProvider.class})
    public DefaultJerseyTagsProvider jerseyTagsProvider() {
        return new DefaultJerseyTagsProvider();
    }

    @Bean
    public ResourceConfigCustomizer jerseyResourceConfigCustomizer(MeterRegistry meterRegistry, JerseyServerMetricsProperties properties, JerseyTagsProvider tagsProvider) {
        return config -> config.register((Object)new MetricsApplicationEventListener(meterRegistry, tagsProvider, properties.getRequestsMetricName(), properties.isAutoTimeRequests(), new AnnotationFinder(){

            public <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
                return (A)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, annotationType);
            }
        }));
    }
}

