/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.web.client;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.lang.NonNull;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.web.client.DefaultRestTemplateExchangeTagsProvider;
import io.micrometer.spring.web.client.MetricsRestTemplateCustomizer;
import io.micrometer.spring.web.client.RestTemplateExchangeTagsProvider;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate", "org.springframework.web.client.AsyncRestTemplate", "org.springframework.boot.web.client.RestTemplateCustomizer"})
public class RestTemplateMetricsConfiguration {
    private final Logger logger = LoggerFactory.getLogger(RestTemplateMetricsConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={RestTemplateExchangeTagsProvider.class})
    public DefaultRestTemplateExchangeTagsProvider restTemplateTagConfigurer() {
        return new DefaultRestTemplateExchangeTagsProvider();
    }

    @Bean
    public MetricsRestTemplateCustomizer metricsRestTemplateCustomizer(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider restTemplateTagConfigurer, MetricsProperties properties) {
        return new MetricsRestTemplateCustomizer(meterRegistry, restTemplateTagConfigurer, properties.getWeb().getClient().getRequestsMetricName());
    }

    @Bean
    public SmartInitializingSingleton metricsAsyncRestTemplateInitializer(ObjectProvider<List<AsyncRestTemplate>> asyncRestTemplatesProvider, MetricsRestTemplateCustomizer customizer) {
        return () -> {
            List asyncRestTemplates = (List)asyncRestTemplatesProvider.getIfAvailable();
            if (!CollectionUtils.isEmpty((Collection)asyncRestTemplates)) {
                asyncRestTemplates.forEach(customizer::customize);
            }
        };
    }

    @Bean
    @Order(value=0)
    public MeterRegistryCustomizer limitCardinalityOfUriTag(MetricsProperties properties) {
        final String metricName = properties.getWeb().getClient().getRequestsMetricName();
        return r -> r.config().meterFilter(MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)properties.getWeb().getClient().getMaxUriTags(), (MeterFilter)new MeterFilter(){
            private AtomicBoolean alreadyWarned = new AtomicBoolean(false);

            @NonNull
            public MeterFilterReply accept(@NonNull Meter.Id id) {
                if (this.alreadyWarned.compareAndSet(false, true)) {
                    RestTemplateMetricsConfiguration.this.logger.warn("Reached the maximum number of URI tags for '" + metricName + "'. Are you using uriVariables on RestTemplate calls?");
                }
                return MeterFilterReply.DENY;
            }
        }));
    }
}

