/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractCompositeCustomizer<C, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCompositeCustomizer.class);
    private final List<C> members;

    protected AbstractCompositeCustomizer(List<C> members) {
        this.members = members;
    }

    protected AbstractCompositeCustomizer() {
        this(new CopyOnWriteArrayList());
    }

    public synchronized void add(C customizer) {
        assert (this.members instanceof CopyOnWriteArrayList) : "only allow adding to root customizer";
        int insertionIndex = Collections.binarySearch(this.members, customizer, OrderUtil.COMPARATOR);
        if (insertionIndex < 0) {
            insertionIndex ^= 0xFFFFFFFF;
        }
        this.members.add(insertionIndex, customizer);
    }

    protected abstract C specializeForChannel(C var1, Channel var2, R var3);

    protected abstract C makeNewComposite(List<C> var1);

    @NonNull
    public final C specializeForChannel(@NonNull Channel channel, @NonNull R role) {
        return this.specialize(c -> this.specializeForChannel(c, channel, role));
    }

    protected final C specialize(UnaryOperator<C> specializeAction) {
        ArrayList specialized = null;
        for (int i = 0; i < this.members.size(); ++i) {
            Object nev;
            C old = this.members.get(i);
            try {
                nev = specializeAction.apply(old);
                Objects.requireNonNull(nev, "specializeForChannel must not return null");
            }
            catch (Exception e) {
                LOG.error("Failed to specialize customizer", (Throwable)e);
                nev = old;
            }
            if (specialized == null) {
                if (nev == old) continue;
                specialized = new ArrayList(this.members.size());
                specialized.addAll(this.members.subList(0, i));
            }
            specialized.add(nev);
        }
        if (specialized == null) {
            return (C)this;
        }
        return this.makeNewComposite(specialized);
    }

    protected final void forEach(Consumer<C> consumer) {
        for (C member : this.members) {
            try {
                consumer.accept(member);
            }
            catch (Exception e) {
                LOG.error("Failed to trigger customizer event", (Throwable)e);
            }
        }
    }
}

