/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.netty.util.concurrent.OrderedEventExecutor;

@Internal
public final class EventLoopFlow {
    private static final boolean STRICT_CHECKING = false;
    private final OrderedEventExecutor loop;
    private int submitGeneration = 0;
    private volatile int runGeneration = 0;

    public EventLoopFlow(OrderedEventExecutor loop) {
        this.loop = loop;
    }

    public boolean executeNow(Runnable delayTask) {
        int generation = this.submitGeneration++;
        if (this.loop.inEventLoop() && this.runGeneration == generation) {
            this.runGeneration = generation + 1;
            return true;
        }
        this.loop.execute((Runnable)new Delayed(delayTask, generation));
        return false;
    }

    private final class Delayed
    implements Runnable {
        private final Runnable task;
        private final int generation;

        private Delayed(Runnable task, int generation) {
            this.task = task;
            this.generation = generation;
        }

        @Override
        public void run() {
            if (EventLoopFlow.this.runGeneration != this.generation) {
                throw new IllegalStateException("Improper run order. Expected " + this.generation + ", was " + EventLoopFlow.this.runGeneration);
            }
            try {
                this.task.run();
            }
            finally {
                EventLoopFlow.this.runGeneration = this.generation + 1;
            }
        }
    }
}

