/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.context.annotation.Primary;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.hateos.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import java.net.URI;
import javax.inject.Singleton;

@Singleton
@Primary
@Produces
public class HttpStatusHandler
implements ExceptionHandler<HttpStatusException, HttpResponse> {
    @Override
    public HttpResponse handle(HttpRequest request, HttpStatusException exception) {
        Object body = exception.getBody().orElseGet(() -> {
            JsonError error = new JsonError(exception.getMessage());
            error.link(Link.SELF, Link.of((URI)request.getUri()));
            return error;
        });
        return HttpResponse.status((HttpStatus)exception.getStatus()).body(body);
    }
}

