/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.types.files;

import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;

public class StreamedFile
implements FileCustomizableResponseType {
    private final String name;
    private final long lastModified;
    private final InputStream inputStream;
    private final long length;

    public StreamedFile(InputStream inputStream, String name) {
        this(inputStream, name, Instant.now().toEpochMilli());
    }

    public StreamedFile(InputStream inputStream, String name, long lastModified) {
        this(inputStream, name, lastModified, -1L);
    }

    public StreamedFile(InputStream inputStream, String name, long lastModified, long contentLength) {
        this.name = name;
        this.lastModified = lastModified;
        this.inputStream = inputStream;
        this.length = contentLength;
    }

    public StreamedFile(URL url) {
        String path = url.getPath();
        int idx = path.lastIndexOf(File.separatorChar);
        this.name = idx > -1 ? path.substring(idx + 1) : path;
        try {
            URLConnection con = url.openConnection();
            this.lastModified = con.getLastModified();
            this.inputStream = con.getInputStream();
            this.length = con.getContentLengthLong();
        }
        catch (IOException e) {
            throw new CustomizableResponseTypeException("Could not open a connection to the URL: " + path, e);
        }
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

