/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.context;

import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import javax.inject.Singleton;

@Singleton
@Internal
final class ServerRequestContextInstrumentation
implements Function<Runnable, Runnable>,
RunnableInstrumenter,
ReactiveInstrumenter,
BeanCreatedEventListener<ThreadFactory> {
    ServerRequestContextInstrumentation() {
    }

    @Override
    public Runnable apply(Runnable runnable) {
        return ServerRequestContextInstrumentation.instrumentRunnable(runnable);
    }

    public Runnable instrument(Runnable command) {
        return this.apply(command);
    }

    public ThreadFactory onCreated(BeanCreatedEvent<ThreadFactory> event) {
        ThreadFactory original = (ThreadFactory)event.getBean();
        return r -> {
            Optional httpRequest = ServerRequestContext.currentRequest();
            return original.newThread(httpRequest.map(objectHttpRequest -> ServerRequestContext.instrument((HttpRequest)objectHttpRequest, (Runnable)r)).orElse(r));
        };
    }

    private static Runnable instrumentRunnable(Runnable runnable) {
        Optional httpRequest = ServerRequestContext.currentRequest();
        return httpRequest.map(objectHttpRequest -> ServerRequestContext.instrument((HttpRequest)objectHttpRequest, (Runnable)runnable)).orElse(runnable);
    }

    public Optional<RunnableInstrumenter> newInstrumentation() {
        Optional httpRequest = ServerRequestContext.currentRequest();
        return httpRequest.map(request -> new RunnableInstrumenter((HttpRequest)request){
            final /* synthetic */ HttpRequest val$request;
            {
                this.val$request = httpRequest;
            }

            public Runnable instrument(Runnable command) {
                return ServerRequestContext.instrument((HttpRequest)this.val$request, (Runnable)command);
            }
        });
    }

    @Singleton
    static class ExecutorServiceInstrumentation
    implements BeanCreatedEventListener<ExecutorService> {
        ExecutorServiceInstrumentation() {
        }

        public final ExecutorService onCreated(BeanCreatedEvent<ExecutorService> event) {
            final ExecutorService executorService = (ExecutorService)event.getBean();
            if (executorService instanceof ScheduledExecutorService) {
                return new InstrumentedScheduledExecutorService(){

                    public ScheduledExecutorService getTarget() {
                        return (ScheduledExecutorService)executorService;
                    }

                    public <T> Callable<T> instrument(Callable<T> task) {
                        return this.doInstrument(task);
                    }

                    public Runnable instrument(Runnable command) {
                        return ServerRequestContextInstrumentation.instrumentRunnable(command);
                    }
                };
            }
            return new InstrumentedExecutorService(){

                public ExecutorService getTarget() {
                    return executorService;
                }

                public <T> Callable<T> instrument(Callable<T> task) {
                    return this.doInstrument(task);
                }

                public Runnable instrument(Runnable command) {
                    return ServerRequestContextInstrumentation.instrumentRunnable(command);
                }
            };
        }

        private <T> Callable<T> doInstrument(Callable<T> task) {
            Optional current = ServerRequestContext.currentRequest();
            return current.map(objectHttpRequest -> () -> ServerRequestContext.with((HttpRequest)objectHttpRequest, (Callable)task)).orElse(task);
        }
    }
}

