/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.util.HttpClientAddressResolver;
import io.micronaut.http.server.util.ProxyHeaderParser;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Singleton;

@Singleton
public class DefaultHttpClientAddressResolver
implements HttpClientAddressResolver {
    private final HttpServerConfiguration serverConfiguration;

    public DefaultHttpClientAddressResolver(HttpServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    public String resolve(@Nonnull HttpRequest request) {
        String configuredHeader = this.serverConfiguration.getClientAddressHeader();
        if (configuredHeader != null) {
            return (String)request.getHeaders().get((CharSequence)configuredHeader);
        }
        ProxyHeaderParser proxyHeaderParser = new ProxyHeaderParser(request);
        List<String> addresses = proxyHeaderParser.getFor();
        if (addresses.isEmpty()) {
            return request.getRemoteAddress().getHostString();
        }
        return addresses.get(0);
    }
}

