/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.context;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.server.context.ServerRequestContextInvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Filter(value={"/**"})
@Internal
public final class ServerRequestContextFilter
implements HttpServerFilter {
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;

    public ServerRequestContextFilter(List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this.invocationInstrumenterFactories = invocationInstrumenterFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        InvocationInstrumenter invocationInstrumenter = InvocationInstrumenter.combine(this.getInvocationInstrumenter(request));
        try {
            invocationInstrumenter.beforeInvocation();
            final Publisher actual = chain.proceed(request);
            final InvocationInstrumenter invocationInstrumenterAfterProceed = InvocationInstrumenter.combine(this.getInvocationInstrumenter(request));
            Publisher publisher = new Publisher<MutableHttpResponse<?>>(){

                public void subscribe(Subscriber<? super MutableHttpResponse<?>> actualSubscriber) {
                    invocationInstrumenterAfterProceed.beforeInvocation();
                    try {
                        actual.subscribe(actualSubscriber);
                    }
                    finally {
                        invocationInstrumenterAfterProceed.afterInvocation();
                    }
                }
            };
            return publisher;
        }
        finally {
            invocationInstrumenter.afterInvocation();
        }
    }

    public int getOrder() {
        return -1000;
    }

    private List<InvocationInstrumenter> getInvocationInstrumenter(HttpRequest<?> request) {
        ArrayList<InvocationInstrumenter> instrumenters = new ArrayList<InvocationInstrumenter>(this.invocationInstrumenterFactories.size() + 1);
        instrumenters.add(new ServerRequestContextInvocationInstrumenter(request));
        for (InvocationInstrumenterFactory instrumenterFactory : this.invocationInstrumenterFactories) {
            InvocationInstrumenter instrumenter = instrumenterFactory.newInvocationInstrumenter();
            if (instrumenter == null) continue;
            instrumenters.add(instrumenter);
        }
        return instrumenters;
    }
}

