/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.server.cors.CorsFilter;
import io.micronaut.http.server.cors.CorsUtil;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;

@Requires(property="micronaut.server.dispatch-options-requests", value="true", defaultValue="false")
@ServerFilter(value={"/**"})
@Internal
public final class OptionsFilter
implements Ordered {
    public static final String PREFIX = "micronaut.server.dispatch-options-requests";
    private final Router router;

    public OptionsFilter(Router router) {
        this.router = router;
    }

    @RequestFilter
    @Nullable
    @Internal
    public HttpResponse<?> filterRequest(HttpRequest<?> request) {
        if (request.getMethod() != HttpMethod.OPTIONS) {
            return null;
        }
        if (CorsUtil.isPreflightRequest(request)) {
            return null;
        }
        if (this.hasOptionsRouteMatch(request)) {
            return null;
        }
        MutableHttpResponse mutableHttpResponse = HttpResponse.status((HttpStatus)HttpStatus.OK);
        this.router.findAny((CharSequence)request.getUri().toString(), request).map(UriRouteMatch::getHttpMethod).map(Enum::toString).forEach(allow -> mutableHttpResponse.header((CharSequence)"Allow", (CharSequence)allow));
        mutableHttpResponse.header((CharSequence)"Allow", (CharSequence)HttpMethod.OPTIONS.toString());
        return mutableHttpResponse;
    }

    private boolean hasOptionsRouteMatch(HttpRequest<?> request) {
        return request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).map(routeMatch -> {
            if (routeMatch instanceof UriRouteMatch) {
                UriRouteMatch uriRouteMatch = (UriRouteMatch)routeMatch;
                return uriRouteMatch.getHttpMethod() == HttpMethod.OPTIONS;
            }
            return true;
        }).orElse(false);
    }

    public int getOrder() {
        return CorsFilter.CORS_FILTER_ORDER + 10;
    }
}

