/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ErrorExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
@Produces
public class UnsatisfiedRouteHandler
extends ErrorExceptionHandler<UnsatisfiedRouteException> {
    public UnsatisfiedRouteHandler(ErrorResponseProcessor<?> responseProcessor) {
        super(responseProcessor);
    }

    @Override
    @NonNull
    protected Error error(final UnsatisfiedRouteException exception) {
        return new Error(){

            @Override
            public String getMessage() {
                return exception.getMessage();
            }

            @Override
            public Optional<String> getPath() {
                return Optional.of("/" + exception.getArgument().getName());
            }
        };
    }
}

