/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.http.HttpStatus;
import io.micronaut.http.exceptions.HttpStatusException;
import java.util.Collection;

public final class UnsupportedMediaException
extends HttpStatusException {
    private final String contentType;
    private final Collection<String> acceptableContentTypes;

    public UnsupportedMediaException(String contentType, Collection<String> acceptableContentTypes) {
        super(HttpStatus.UNSUPPORTED_MEDIA_TYPE, "Content Type [" + contentType + "] not allowed. Allowed types: " + acceptableContentTypes);
        this.contentType = contentType;
        this.acceptableContentTypes = acceptableContentTypes;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Collection<String> getAcceptableContentTypes() {
        return this.acceptableContentTypes;
    }
}

