/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.loggers.impl;

import io.micronaut.context.annotation.Requires;
import io.micronaut.management.endpoint.loggers.LogLevel;
import io.micronaut.management.endpoint.loggers.LoggerConfiguration;
import io.micronaut.management.endpoint.loggers.LoggersEndpoint;
import io.micronaut.management.endpoint.loggers.LoggersManager;
import io.micronaut.management.endpoint.loggers.LoggingSystem;
import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requires(beans={LoggersEndpoint.class})
public class DefaultLoggersManager
implements LoggersManager<Map<String, Object>> {
    private static final String LEVELS = "levels";
    private static final String LOGGERS = "loggers";

    @Override
    public Publisher<Map<String, Object>> getLoggers(LoggingSystem loggingSystem) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put(LEVELS, DefaultLoggersManager.getLogLevels());
        data.put(LOGGERS, DefaultLoggersManager.getLoggerData(loggingSystem.getLoggers()));
        return Flowable.just(data);
    }

    @Override
    public Publisher<Map<String, Object>> getLogger(LoggingSystem loggingSystem, String name) {
        return Flowable.just(DefaultLoggersManager.getLoggerData(loggingSystem.getLogger(name)));
    }

    @Override
    public void setLogLevel(LoggingSystem loggingSystem, String name, LogLevel level) {
        loggingSystem.setLogLevel(name, level);
    }

    private static Map<String, Object> getLoggerData(Collection<LoggerConfiguration> configurations) {
        return configurations.stream().collect(Collectors.toMap(LoggerConfiguration::getName, LoggerConfiguration::getData));
    }

    private static Map<String, Object> getLoggerData(LoggerConfiguration configuration) {
        return configuration.getData();
    }

    private static List<LogLevel> getLogLevels() {
        return Arrays.asList(LogLevel.values());
    }
}

