/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.processors;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.async.subscriber.Completable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.type.Argument;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.EndpointDefaultConfiguration;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Selector;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.RouteBuilder;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

abstract class AbstractEndpointRouteBuilder
extends DefaultRouteBuilder
implements ExecutableMethodProcessor<Endpoint>,
Completable {
    private static final Pattern ENDPOINT_ID_PATTERN = Pattern.compile("\\w+");
    private Map<Class, Optional<String>> endpointIds = new ConcurrentHashMap<Class, Optional<String>>();
    private final ApplicationContext beanContext;
    private final EndpointDefaultConfiguration endpointDefaultConfiguration;

    AbstractEndpointRouteBuilder(ApplicationContext applicationContext, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService<?> conversionService, EndpointDefaultConfiguration endpointDefaultConfiguration) {
        super((ExecutionHandleLocator)applicationContext, uriNamingStrategy, conversionService);
        this.beanContext = applicationContext;
        this.endpointDefaultConfiguration = endpointDefaultConfiguration;
    }

    protected abstract Class<? extends Annotation> getSupportedAnnotation();

    protected abstract void registerRoute(ExecutableMethod<?, ?> var1, String var2);

    public final void onComplete() {
        this.endpointIds.clear();
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        Class declaringType = method.getDeclaringType();
        if (method.hasStereotype(this.getSupportedAnnotation())) {
            Optional<String> endPointId = this.resolveActiveEndPointId(declaringType);
            endPointId.ifPresent(id -> {
                ClassLoadingReporter.reportBeanPresent((Class)method.getReturnType().getType());
                for (Class argumentType : method.getArgumentTypes()) {
                    ClassLoadingReporter.reportBeanPresent((Class)argumentType);
                }
                this.registerRoute(method, (String)id);
            });
        }
    }

    protected Optional<String> resolveActiveEndPointId(Class<?> declaringType) {
        return this.endpointIds.computeIfAbsent(declaringType, aClass -> {
            BeanDefinition beanDefinition;
            Optional opt = this.beanContext.findBeanDefinition(declaringType);
            if (opt.isPresent() && (beanDefinition = (BeanDefinition)opt.get()).hasStereotype(Endpoint.class)) {
                String id = beanDefinition.getValue(Endpoint.class, String.class).orElse(null);
                if (id == null || !ENDPOINT_ID_PATTERN.matcher(id).matches()) {
                    id = NameUtils.hyphenate((String)beanDefinition.getName());
                }
                return Optional.ofNullable(id);
            }
            return Optional.empty();
        });
    }

    protected UriTemplate buildUriTemplate(ExecutableMethod<?, ?> method, String id) {
        UriTemplate template = new UriTemplate((CharSequence)this.resolveUriByRouteId(id));
        for (Argument argument : method.getArguments()) {
            if (!this.isPathParameter(argument)) continue;
            template = template.nest((CharSequence)("/{" + argument.getName() + "}"));
        }
        return template;
    }

    String resolveUriByRouteId(String id) {
        String uri = this.uriNamingStrategy.resolveUri(id);
        if (this.endpointDefaultConfiguration.getPath().equals("/") && uri.charAt(0) == '/') {
            return uri;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.endpointDefaultConfiguration.getPath());
        sb.append(uri);
        return sb.toString();
    }

    protected boolean isPathParameter(Argument argument) {
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        return annotationMetadata.hasDeclaredAnnotation(Selector.class);
    }
}

