/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.routes.impl;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.MediaType;
import io.micronaut.management.endpoint.routes.RouteData;
import io.micronaut.management.endpoint.routes.RouteDataCollector;
import io.micronaut.management.endpoint.routes.RoutesEndpoint;
import io.micronaut.web.router.UriRoute;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requires(beans={RoutesEndpoint.class})
public class RxJavaRouteDataCollector
implements RouteDataCollector<Map<String, Object>> {
    private final RouteData routeData;
    private final ExecutorService executorService;

    public RxJavaRouteDataCollector(RouteData routeData, @Named(value="io") ExecutorService executorService) {
        this.routeData = routeData;
        this.executorService = executorService;
    }

    @Override
    public Publisher<Map<String, Object>> getData(Stream<UriRoute> routes) {
        List routeList = routes.collect(Collectors.toList());
        ConcurrentHashMap routeMap = new ConcurrentHashMap(routeList.size());
        return Flowable.fromIterable(routeList).subscribeOn(Schedulers.from((Executor)this.executorService)).collectInto(routeMap, (map, route) -> map.put(this.getRouteKey((UriRoute)route), this.routeData.getData((UriRoute)route))).toFlowable();
    }

    protected String getRouteKey(UriRoute route) {
        String produces = route.getProduces().stream().map(MediaType::toString).collect(Collectors.joining(" || "));
        return "{[" + route.getUriMatchTemplate() + "],method=[" + route.getHttpMethod().name() + "],produces=[" + produces + "]}";
    }
}

