/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator.discovery;

import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Requires(beans={DiscoveryClient.class})
@Singleton
public class DiscoveryClientHealthIndicator
implements HealthIndicator {
    private final DiscoveryClient discoveryClient;

    public DiscoveryClientHealthIndicator(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public Publisher<HealthResult> getResult() {
        return Flowable.fromPublisher((Publisher)this.discoveryClient.getServiceIds()).flatMap(ids -> {
            List serviceMap = ids.stream().map(id -> {
                Flowable serviceList = Flowable.fromPublisher((Publisher)this.discoveryClient.getInstances(id));
                return serviceList.map(serviceInstances -> Collections.singletonMap(id, serviceInstances));
            }).collect(Collectors.toList());
            Flowable mergedServiceMap = Flowable.merge(serviceMap);
            return mergedServiceMap.reduce(new LinkedHashMap(), (allServiceMap, service) -> {
                allServiceMap.putAll(service);
                return allServiceMap;
            }).map(details -> {
                HealthResult.Builder builder = HealthResult.builder(this.discoveryClient.getDescription(), HealthStatus.UP);
                Stream entryStream = details.entrySet().stream();
                Map<String, Object> value = entryStream.collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ServiceInstance::getURI).collect(Collectors.toList())));
                builder.details(Collections.singletonMap("services", value));
                return builder.build();
            }).toFlowable();
        }).onErrorReturn(throwable -> {
            HealthResult.Builder builder = HealthResult.builder(this.discoveryClient.getDescription(), HealthStatus.DOWN);
            builder.exception((Throwable)throwable);
            return builder.build();
        });
    }
}

