/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint;

import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.management.endpoint.annotation.Endpoint;
import java.util.Optional;

@Introspected
public class EndpointEnabledCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        AnnotationMetadataProvider component = context.getComponent();
        AnnotationMetadata annotationMetadata = component.getAnnotationMetadata();
        if (annotationMetadata.hasDeclaredAnnotation(Endpoint.class)) {
            Boolean defaultEnabled = annotationMetadata.getValue(Endpoint.class, "defaultEnabled", Boolean.class).orElse(true);
            String prefix = annotationMetadata.getValue(Endpoint.class, "prefix", String.class).orElse(null);
            String id = annotationMetadata.getValue(Endpoint.class, "value", String.class).orElse(null);
            String defaultId = annotationMetadata.getValue(Endpoint.class, "defaultConfigurationId", String.class).orElse(null);
            BeanContext beanContext = context.getBeanContext();
            if (beanContext instanceof PropertyResolver) {
                PropertyResolver propertyResolver = (PropertyResolver)beanContext;
                Optional enabled = propertyResolver.getProperty(String.format("%s.%s.enabled", prefix, id), Boolean.class);
                if (enabled.isPresent()) {
                    return (Boolean)enabled.get();
                }
                enabled = propertyResolver.getProperty(String.format("%s.%s.enabled", prefix, defaultId), Boolean.class);
                return enabled.orElse(defaultEnabled);
            }
        }
        return true;
    }
}

