/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator.jdbc;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.AsyncSingleResultPublisher;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.aggregator.HealthAggregator;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.reactivex.Flowable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.reactivestreams.Publisher;

@Singleton
@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="endpoints.health.jdbc.enabled", notEquals="false")})
public class JdbcIndicator
implements HealthIndicator {
    private static final String NAME = "jdbc";
    private static final int CONNECTION_TIMEOUT = 3;
    private final ExecutorService executorService;
    private final DataSource[] dataSources;
    private final HealthAggregator healthAggregator;

    @Inject
    public JdbcIndicator(@Named(value="io") ExecutorService executorService, DataSource[] dataSources, HealthAggregator healthAggregator) {
        this.executorService = executorService;
        this.dataSources = dataSources;
        this.healthAggregator = healthAggregator;
    }

    private Publisher<HealthResult> getResult(DataSource dataSource) {
        if (this.executorService == null) {
            throw new IllegalStateException("I/O ExecutorService is null");
        }
        return new AsyncSingleResultPublisher(this.executorService, () -> {
            String key;
            LinkedHashMap<String, String> details;
            Optional<Object> throwable;
            block19: {
                throwable = Optional.empty();
                details = null;
                try (Connection connection = dataSource.getConnection();){
                    if (connection.isValid(3)) {
                        DatabaseMetaData metaData = connection.getMetaData();
                        key = metaData.getURL();
                        details = new LinkedHashMap<String, String>(1);
                        details.put("database", metaData.getDatabaseProductName());
                        details.put("version", metaData.getDatabaseProductVersion());
                        break block19;
                    }
                    throw new SQLException("Connection was not valid");
                }
                catch (SQLException e) {
                    throwable = Optional.of(e);
                    try {
                        key = dataSource.getClass().getMethod("getUrl", new Class[0]).invoke((Object)dataSource, new Object[0]).toString();
                    }
                    catch (Exception n) {
                        key = dataSource.getClass().getName() + "@" + Integer.toHexString(dataSource.hashCode());
                    }
                }
            }
            HealthResult.Builder builder = HealthResult.builder(key);
            if (throwable.isPresent()) {
                builder.exception((Throwable)throwable.get());
                builder.status(HealthStatus.DOWN);
            } else {
                builder.status(HealthStatus.UP);
                builder.details(details);
            }
            return builder.build();
        });
    }

    @Override
    public Publisher<HealthResult> getResult() {
        if (this.dataSources.length == 0) {
            return Flowable.empty();
        }
        return this.healthAggregator.aggregate(NAME, (Publisher<HealthResult>)Flowable.merge((Iterable)Arrays.stream(this.dataSources).map(ds -> this.getResult((DataSource)ds)).collect(Collectors.toList())));
    }
}

