/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint;

import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.EndpointConfiguration;
import io.micronaut.management.endpoint.EndpointDefaultConfiguration;
import io.micronaut.management.endpoint.annotation.Endpoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class EndpointSensitivityProcessor
implements ExecutableMethodProcessor<Endpoint> {
    private final List<EndpointConfiguration> endpointConfigurations;
    private final EndpointDefaultConfiguration defaultConfiguration;
    private Map<ExecutableMethod, Boolean> endpointMethods = new HashMap<ExecutableMethod, Boolean>();

    public EndpointSensitivityProcessor(List<EndpointConfiguration> endpointConfigurations, EndpointDefaultConfiguration defaultConfiguration) {
        this.endpointConfigurations = CollectionUtils.unmodifiableList(endpointConfigurations);
        this.defaultConfiguration = defaultConfiguration;
    }

    public Map<ExecutableMethod, Boolean> getEndpointMethods() {
        return this.endpointMethods;
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        Optional optionalId = beanDefinition.stringValue(Endpoint.class);
        optionalId.ifPresent(id -> {
            EndpointConfiguration configuration = this.endpointConfigurations.stream().filter(c -> c.getId().equals(id)).findFirst().orElseGet(() -> new EndpointConfiguration((String)id, this.defaultConfiguration));
            boolean sensitive = configuration.isSensitive().orElseGet(() -> beanDefinition.booleanValue(Endpoint.class, "defaultSensitive").orElseGet(() -> beanDefinition.getDefaultValue(Endpoint.class, "defaultSensitive", Boolean.class).orElse(true)));
            this.endpointMethods.put(method, sensitive);
        });
    }
}

