/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.caches;

import io.micronaut.cache.CacheInfo;
import io.micronaut.cache.CacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.management.endpoint.annotation.Delete;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.annotation.Selector;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.reactivestreams.Publisher;

@Endpoint(id="caches", defaultEnabled=false)
public class CachesEndpoint {
    public static final String NAME = "caches";
    private final CacheManager<Object> cacheManager;

    public CachesEndpoint(CacheManager<Object> cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Read
    public Single<Map<String, Object>> getCaches() {
        return Flowable.fromIterable((Iterable)this.cacheManager.getCacheNames()).flatMapMaybe(n -> Flowable.fromPublisher((Publisher)this.cacheManager.getCache(n).getCacheInfo()).firstElement()).reduce(new HashMap(), (seed, info) -> {
            seed.put(info.getName(), info.get());
            return seed;
        }).map(objectObjectHashMap -> Collections.singletonMap(NAME, objectObjectHashMap));
    }

    @Read
    public Maybe<Map<String, Object>> getCache(@NotBlank @Selector String name) {
        try {
            SyncCache cache = this.cacheManager.getCache(name);
            return Flowable.fromPublisher((Publisher)cache.getCacheInfo()).map(CacheInfo::get).singleElement();
        }
        catch (ConfigurationException e) {
            return Maybe.empty();
        }
    }

    @Delete
    public Maybe<Boolean> invalidateCaches() {
        return Flowable.fromIterable((Iterable)this.cacheManager.getCacheNames()).map(arg_0 -> this.cacheManager.getCache(arg_0)).flatMap(c -> Publishers.fromCompletableFuture(() -> c.async().invalidateAll())).reduce((aBoolean, aBoolean2) -> aBoolean != false && aBoolean2 != false);
    }

    @Delete
    public Maybe<Boolean> invalidateCache(@NotBlank @Selector String name) {
        try {
            SyncCache cache = this.cacheManager.getCache(name);
            return Maybe.create(emitter -> cache.async().invalidateAll().whenComplete((aBoolean, throwable) -> {
                if (throwable != null) {
                    emitter.onError(throwable);
                } else {
                    emitter.onSuccess(aBoolean);
                    emitter.onComplete();
                }
            }));
        }
        catch (ConfigurationException e) {
            return Maybe.empty();
        }
    }
}

