/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.env;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.SupplierUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EnvironmentFilterSpecification {
    private static final Supplier<List<Pattern>> LEGACY_MASK_PATTERNS = SupplierUtil.memoized(() -> Stream.of(".*password.*", ".*credential.*", ".*certificate.*", ".*key.*", ".*secret.*", ".*token.*").map(s -> Pattern.compile(s, 2)).collect(Collectors.toList()));
    private boolean allMasked = true;
    private final List<Predicate<String>> exclusions = new ArrayList<Predicate<String>>();

    EnvironmentFilterSpecification() {
    }

    @NonNull
    public EnvironmentFilterSpecification maskAll() {
        this.allMasked = true;
        return this;
    }

    @NonNull
    public EnvironmentFilterSpecification maskNone() {
        this.allMasked = false;
        return this;
    }

    @NonNull
    public EnvironmentFilterSpecification exclude(@NonNull Predicate<String> keyPredicate) {
        this.exclusions.add(keyPredicate);
        return this;
    }

    @NonNull
    public EnvironmentFilterSpecification exclude(String ... keys) {
        if (keys.length > 0) {
            if (keys.length == 1) {
                this.exclusions.add(name -> keys[0].equals(name));
            } else {
                List<String> keysList = Arrays.asList(keys);
                this.exclusions.add(keysList::contains);
            }
        }
        return this;
    }

    @NonNull
    public EnvironmentFilterSpecification exclude(Pattern ... keyPatterns) {
        if (keyPatterns.length > 0) {
            if (keyPatterns.length == 1) {
                this.exclusions.add(name -> keyPatterns[0].matcher((CharSequence)name).matches());
            } else {
                this.exclusions.add(name -> Arrays.stream(keyPatterns).anyMatch(pattern -> pattern.matcher((CharSequence)name).matches()));
            }
        }
        return this;
    }

    @NonNull
    public EnvironmentFilterSpecification legacyMasking() {
        this.allMasked = false;
        for (Pattern pattern : LEGACY_MASK_PATTERNS.get()) {
            this.exclude(pattern);
        }
        return this;
    }

    FilterResult test(String key) {
        for (Predicate<String> exclusion : this.exclusions) {
            if (!exclusion.test(key)) continue;
            return this.allMasked ? FilterResult.PLAIN : FilterResult.MASK;
        }
        return this.allMasked ? FilterResult.MASK : FilterResult.PLAIN;
    }

    static enum FilterResult {
        HIDE,
        MASK,
        PLAIN;

    }
}

