/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.verify;

import io.mockk.Invocation;
import io.mockk.MockKGateway;
import io.mockk.RecordedCall;
import io.mockk.impl.log.SafeToString;
import io.mockk.impl.stub.StubRepository;
import io.mockk.impl.verify.LCSMatchingAlgo;
import io.mockk.impl.verify.VerificationHelpers;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\nH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/mockk/impl/verify/OrderedCallVerifier;", "Lio/mockk/MockKGateway$CallVerifier;", "stubRepo", "Lio/mockk/impl/stub/StubRepository;", "safeToString", "Lio/mockk/impl/log/SafeToString;", "(Lio/mockk/impl/stub/StubRepository;Lio/mockk/impl/log/SafeToString;)V", "captureBlocks", "", "Lkotlin/Function0;", "", "getSafeToString", "()Lio/mockk/impl/log/SafeToString;", "getStubRepo", "()Lio/mockk/impl/stub/StubRepository;", "captureArguments", "verify", "Lio/mockk/MockKGateway$VerificationResult;", "verificationSequence", "", "Lio/mockk/RecordedCall;", "params", "Lio/mockk/MockKGateway$VerificationParameters;", "mockk"})
@SourceDebugExtension(value={"SMAP\nOrderedCallVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedCallVerifier.kt\nio/mockk/impl/verify/OrderedCallVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1863#2,2:48\n*S KotlinDebug\n*F\n+ 1 OrderedCallVerifier.kt\nio/mockk/impl/verify/OrderedCallVerifier\n*L\n44#1:48,2\n*E\n"})
public final class OrderedCallVerifier
implements MockKGateway.CallVerifier {
    @NotNull
    private final StubRepository stubRepo;
    @NotNull
    private final SafeToString safeToString;
    @NotNull
    private final List<Function0<Unit>> captureBlocks;

    public OrderedCallVerifier(@NotNull StubRepository stubRepo, @NotNull SafeToString safeToString2) {
        Intrinsics.checkNotNullParameter((Object)stubRepo, (String)"stubRepo");
        Intrinsics.checkNotNullParameter((Object)safeToString2, (String)"safeToString");
        this.stubRepo = stubRepo;
        this.safeToString = safeToString2;
        this.captureBlocks = new ArrayList();
    }

    @NotNull
    public final StubRepository getStubRepo() {
        return this.stubRepo;
    }

    @NotNull
    public final SafeToString getSafeToString() {
        return this.safeToString;
    }

    @NotNull
    public MockKGateway.VerificationResult verify(@NotNull List<RecordedCall> verificationSequence, @NotNull MockKGateway.VerificationParameters params) {
        Intrinsics.checkNotNullParameter(verificationSequence, (String)"verificationSequence");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<Invocation> allCalls = VerificationHelpers.INSTANCE.allInvocations(verificationSequence, this.stubRepo);
        if (verificationSequence.size() > allCalls.size()) {
            return (MockKGateway.VerificationResult)new MockKGateway.VerificationResult.Failure((String)this.safeToString.exec((Function0)new Function0<String>(verificationSequence, allCalls){
                final /* synthetic */ List<RecordedCall> $verificationSequence;
                final /* synthetic */ List<Invocation> $allCalls;
                {
                    this.$verificationSequence = $verificationSequence;
                    this.$allCalls = $allCalls;
                    super(0);
                }

                public final String invoke() {
                    return "fewer calls happened than demanded by order verification sequence. " + VerificationHelpers.reportCalls$default(VerificationHelpers.INSTANCE, this.$verificationSequence, this.$allCalls, null, 4, null);
                }
            }));
        }
        LCSMatchingAlgo lcs = new LCSMatchingAlgo(allCalls, verificationSequence, this.captureBlocks);
        return lcs.lcs() ? (MockKGateway.VerificationResult)new MockKGateway.VerificationResult.OK(lcs.getVerifiedCalls()) : (MockKGateway.VerificationResult)new MockKGateway.VerificationResult.Failure((String)this.safeToString.exec((Function0)new Function0<String>(verificationSequence, allCalls, lcs){
            final /* synthetic */ List<RecordedCall> $verificationSequence;
            final /* synthetic */ List<Invocation> $allCalls;
            final /* synthetic */ LCSMatchingAlgo $lcs;
            {
                this.$verificationSequence = $verificationSequence;
                this.$allCalls = $allCalls;
                this.$lcs = $lcs;
                super(0);
            }

            public final String invoke() {
                return "calls are not in verification order" + VerificationHelpers.INSTANCE.reportCalls(this.$verificationSequence, this.$allCalls, this.$lcs);
            }
        }));
    }

    public void captureArguments() {
        Iterable $this$forEach$iv = this.captureBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }
}

