/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.executor.WorkflowInstanceExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

@Configuration
@ComponentScan(value={"io.nflow.engine"})
public class EngineConfiguration {
    @Bean
    public WorkflowInstanceExecutor nflowExecutor(@NFlow ThreadFactory nflowThreadFactory, Environment env) {
        int threadCount = (Integer)env.getProperty("nflow.executor.thread.count", Integer.class, (Object)(2 * Runtime.getRuntime().availableProcessors()));
        int awaitTerminationSeconds = (Integer)env.getRequiredProperty("nflow.dispatcher.await.termination.seconds", Integer.class);
        int queueSize = (Integer)env.getProperty("nflow.dispatcher.executor.queue.size", Integer.class, (Object)(2 * threadCount));
        int notifyThreshold = (Integer)env.getProperty("nflow.dispatcher.executor.queue.wait_until_threshold", Integer.class, (Object)(queueSize / 2));
        int keepAliveSeconds = (Integer)env.getRequiredProperty("nflow.dispatcher.executor.thread.keepalive.seconds", Integer.class);
        return new WorkflowInstanceExecutor(queueSize, threadCount, notifyThreshold, awaitTerminationSeconds, keepAliveSeconds, nflowThreadFactory);
    }

    @Bean
    @NFlow
    public ThreadFactory nflowThreadFactory() {
        CustomizableThreadFactory factory = new CustomizableThreadFactory("nflow-executor-");
        factory.setThreadGroupName("nflow");
        return factory;
    }

    @Bean
    @NFlow
    public EngineObjectMapperSupplier nflowObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.registerModule((Module)new JodaModule());
        return () -> mapper;
    }

    @Bean
    @NFlow
    public AbstractResource nflowNonSpringWorkflowsListing(Environment env) {
        String filename = env.getProperty("nflow.non_spring_workflows_filename");
        if (filename != null) {
            return new ClassPathResource(filename);
        }
        return new ByteArrayResource(new byte[0]);
    }

    public static interface EngineObjectMapperSupplier
    extends Supplier<ObjectMapper> {
    }
}

