/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.dao;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.dao.DaoUtil;
import io.nflow.engine.internal.dao.ExecutorDao;
import io.nflow.engine.internal.dao.NflowTable;
import io.nflow.engine.internal.dao.PollingBatchException;
import io.nflow.engine.internal.dao.PollingRaceConditionException;
import io.nflow.engine.internal.dao.TableType;
import io.nflow.engine.internal.executor.InstanceInfo;
import io.nflow.engine.internal.executor.WorkflowInstanceExecutor;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.workflow.executor.StateVariableValueTooLongException;
import io.nflow.engine.workflow.instance.QueryWorkflowInstances;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.AbstractInterruptibleBatchPreparedStatementSetter;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Singleton
@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="common jdbctemplate practice, npe is unlikely")
public class WorkflowInstanceDao {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowInstanceDao.class);
    private final ConcurrentMap<Long, String> workflowTypeByWorkflowIdCache = new ConcurrentHashMap<Long, String>();
    final JdbcTemplate jdbc;
    private final NamedParameterJdbcTemplate namedJdbc;
    private final TransactionTemplate transaction;
    final ExecutorDao executorInfo;
    final SQLVariants sqlVariants;
    private final WorkflowInstanceExecutor workflowInstanceExecutor;
    private final long workflowInstanceQueryMaxResults;
    private final long workflowInstanceQueryMaxResultsDefault;
    private final long workflowInstanceQueryMaxActions;
    private final long workflowInstanceQueryMaxActionsDefault;
    private final int workflowInstanceTypeCacheSize;
    private final AtomicBoolean disableBatchUpdates = new AtomicBoolean();
    AtomicInteger instanceStateTextLength = new AtomicInteger();
    AtomicInteger actionStateTextLength = new AtomicInteger();
    AtomicInteger stateVariableValueMaxLength = new AtomicInteger();
    final WorkflowInstanceRowMapper workflowInstanceRowMapper;
    final WorkflowInstanceActionRowMapper workflowInstanceActionRowMapper;

    @Inject
    public WorkflowInstanceDao(SQLVariants sqlVariants, @NFlow JdbcTemplate nflowJdbcTemplate, @NFlow TransactionTemplate transactionTemplate, @NFlow NamedParameterJdbcTemplate nflowNamedParameterJdbcTemplate, ExecutorDao executorDao, WorkflowInstanceExecutor workflowInstanceExecutor, WorkflowInstanceFactory workflowInstanceFactory, Environment env) {
        this.sqlVariants = sqlVariants;
        this.jdbc = nflowJdbcTemplate;
        this.transaction = transactionTemplate;
        this.namedJdbc = nflowNamedParameterJdbcTemplate;
        this.executorInfo = executorDao;
        this.workflowInstanceExecutor = workflowInstanceExecutor;
        this.workflowInstanceRowMapper = new WorkflowInstanceRowMapper(sqlVariants, workflowInstanceFactory);
        this.workflowInstanceActionRowMapper = new WorkflowInstanceActionRowMapper(sqlVariants);
        this.workflowInstanceQueryMaxResults = (Long)env.getRequiredProperty("nflow.workflow.instance.query.max.results", Long.class);
        this.workflowInstanceQueryMaxResultsDefault = (Long)env.getRequiredProperty("nflow.workflow.instance.query.max.results.default", Long.class);
        this.workflowInstanceQueryMaxActions = (Long)env.getRequiredProperty("nflow.workflow.instance.query.max.actions", Long.class);
        this.workflowInstanceQueryMaxActionsDefault = (Long)env.getRequiredProperty("nflow.workflow.instance.query.max.actions.default", Long.class);
        this.disableBatchUpdates.set((Boolean)env.getRequiredProperty("nflow.db.disable_batch_updates", Boolean.class));
        if (this.disableBatchUpdates.get()) {
            logger.info("nFlow DB batch updates are disabled (system property nflow.db.disable_batch_updates=true)");
        }
        this.workflowInstanceTypeCacheSize = (Integer)env.getRequiredProperty("nflow.db.workflowInstanceType.cacheSize", Integer.class);
        this.instanceStateTextLength.set((Integer)env.getProperty("nflow.workflow.instance.state.text.length", Integer.class, (Object)-1));
        this.actionStateTextLength.set((Integer)env.getProperty("nflow.workflow.action.state.text.length", Integer.class, (Object)-1));
        this.stateVariableValueMaxLength.set((Integer)env.getProperty("nflow.workflow.state.variable.value.length", Integer.class, (Object)-1));
    }

    private int getInstanceStateTextLength() {
        return this.getFieldLength(this.instanceStateTextLength, "state_text", NflowTable.WORKFLOW, "nflow.workflow.instance.state.text.length");
    }

    private int getActionStateTextLength() {
        return this.getFieldLength(this.actionStateTextLength, "state_text", NflowTable.ACTION, "nflow.workflow.action.state.text.length");
    }

    int getStateVariableValueMaxLength() {
        return this.getFieldLength(this.stateVariableValueMaxLength, "state_value", NflowTable.STATE, "nflow.workflow.state.variable.value.length");
    }

    private int getFieldLength(AtomicInteger length, String field, NflowTable table, String property) {
        int value = length.get();
        if (value == -1) {
            value = Optional.ofNullable((Integer)this.jdbc.query("select " + field + " from " + table.main + " where 1=0", (ResultSetExtractor)DaoUtil.firstColumnLengthExtractor)).orElseThrow(() -> new IllegalStateException("Failed to read " + table.main + "." + field + " column length from database, please set correct value to " + property));
            length.set(value);
        }
        return value;
    }

    public long insertWorkflowInstance(WorkflowInstance instance) {
        long id = this.sqlVariants.hasUpdateableCTE() ? this.insertWorkflowInstanceWithCte(instance) : this.insertWorkflowInstanceWithTransaction(instance);
        if (instance.nextActivation != null && instance.nextActivation.isBeforeNow()) {
            this.workflowInstanceExecutor.wakeUpDispatcherIfNeeded();
        }
        return id;
    }

    private long insertWorkflowInstanceWithCte(WorkflowInstance instance) {
        try {
            StringBuilder sqlb = new StringBuilder(256);
            sqlb.append("with wf as (").append(this.insertWorkflowInstanceSql()).append(" returning id)");
            Object[] instanceValues = new Object[]{instance.type, instance.priority, instance.parentWorkflowId, instance.parentActionId, instance.businessKey, instance.externalId, this.executorInfo.getExecutorGroup(), instance.status.name(), instance.state, org.apache.commons.lang3.StringUtils.abbreviate((String)instance.stateText, (int)this.getInstanceStateTextLength()), DaoUtil.toTimestamp((BaseDateTime)instance.nextActivation), instance.signal.orElse(null)};
            int pos = instanceValues.length;
            Object[] args = Arrays.copyOf(instanceValues, pos + instance.stateVariables.size() * 2);
            for (Map.Entry<String, String> variable : instance.stateVariables.entrySet()) {
                sqlb.append(", ins").append(pos).append(" as (").append(this.insertWorkflowInstanceStateSql()).append(" select wf.id,0,?,? from wf)");
                args[pos++] = variable.getKey();
                args[pos++] = variable.getValue();
            }
            sqlb.append(" select wf.id from wf");
            return (Long)this.jdbc.queryForObject(sqlb.toString(), Long.class, args);
        }
        catch (DuplicateKeyException e) {
            logger.warn("Failed to insert workflow instance", (Throwable)e);
            return -1L;
        }
    }

    boolean useBatchUpdate() {
        return this.sqlVariants.useBatchUpdate() && !this.disableBatchUpdates.get();
    }

    String insertWorkflowInstanceSql() {
        return "insert into nflow_workflow(type, priority, parent_workflow_id, parent_action_id, business_key, external_id, executor_group, status, state, state_text, next_activation, workflow_signal) values (?, ?, ?, ?, ?, ?, ?, " + this.sqlVariants.workflowStatus() + ", ?, ?, ?, ?)";
    }

    String insertWorkflowInstanceStateSql() {
        return "insert into nflow_workflow_state(workflow_id, action_id, state_key, state_value)";
    }

    private long insertWorkflowInstanceWithTransaction(final WorkflowInstance instance) {
        return (Long)this.transaction.execute(status -> {
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            try {
                this.jdbc.update(new PreparedStatementCreator(){

                    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="SQL is practically constant")
                    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                        int p = 1;
                        PreparedStatement ps = connection.prepareStatement(WorkflowInstanceDao.this.insertWorkflowInstanceSql(), new String[]{"id"});
                        try {
                            ps.setString(p++, instance.type);
                            ps.setShort(p++, instance.priority);
                            ps.setObject(p++, instance.parentWorkflowId);
                            ps.setObject(p++, instance.parentActionId);
                            ps.setString(p++, instance.businessKey);
                            ps.setString(p++, instance.externalId);
                            ps.setString(p++, WorkflowInstanceDao.this.executorInfo.getExecutorGroup());
                            ps.setString(p++, instance.status.name());
                            ps.setString(p++, instance.state);
                            ps.setString(p++, org.apache.commons.lang3.StringUtils.abbreviate((String)instance.stateText, (int)WorkflowInstanceDao.this.getInstanceStateTextLength()));
                            WorkflowInstanceDao.this.sqlVariants.setDateTime(ps, p++, instance.nextActivation);
                            if (instance.signal.isPresent()) {
                                ps.setInt(p++, instance.signal.get());
                            } else {
                                ps.setNull(p++, 4);
                            }
                        }
                        catch (Exception e) {
                            ps.close();
                            throw e;
                        }
                        return ps;
                    }
                }, (KeyHolder)keyHolder);
            }
            catch (DuplicateKeyException e) {
                logger.warn("Failed to insert workflow instance", (Throwable)e);
                return -1L;
            }
            long id = keyHolder.getKey().longValue();
            this.insertVariables(id, 0L, instance.stateVariables);
            return id;
        });
    }

    void insertVariables(long id, long actionId, Map<String, String> changedStateVariables) {
        if (changedStateVariables.isEmpty()) {
            return;
        }
        if (this.useBatchUpdate()) {
            this.insertVariablesWithBatchUpdate(id, actionId, changedStateVariables);
        } else {
            this.insertVariablesWithMultipleUpdates(id, actionId, changedStateVariables);
        }
    }

    private void insertVariablesWithMultipleUpdates(long id, long actionId, Map<String, String> changedStateVariables) {
        for (Map.Entry<String, String> entry : changedStateVariables.entrySet()) {
            int updated = this.jdbc.update(this.insertWorkflowInstanceStateSql() + " values (?,?,?,?)", new Object[]{id, actionId, entry.getKey(), entry.getValue()});
            if (updated == 1) continue;
            throw new IllegalStateException("Failed to insert state variable " + entry.getKey());
        }
    }

    private void insertVariablesWithBatchUpdate(final long id, final long actionId, Map<String, String> changedStateVariables) {
        final Iterator<Map.Entry<String, String>> variables = changedStateVariables.entrySet().iterator();
        int[] updateStatus = this.jdbc.batchUpdate(this.insertWorkflowInstanceStateSql() + " values (?,?,?,?)", (BatchPreparedStatementSetter)new AbstractInterruptibleBatchPreparedStatementSetter(){

            protected boolean setValuesIfAvailable(PreparedStatement ps, int i) throws SQLException {
                if (!variables.hasNext()) {
                    return false;
                }
                Map.Entry variable = (Map.Entry)variables.next();
                ps.setLong(1, id);
                ps.setLong(2, actionId);
                ps.setString(3, (String)variable.getKey());
                ps.setString(4, (String)variable.getValue());
                return true;
            }
        });
        int updatedRows = 0;
        boolean unknownResults = false;
        for (int i = 0; i < updateStatus.length; ++i) {
            if (updateStatus[i] == -2) {
                unknownResults = true;
                continue;
            }
            if (updateStatus[i] == -3) {
                throw new IllegalStateException("Failed to insert/update state variable at index " + i + " (" + updateStatus[i] + ")");
            }
            updatedRows += updateStatus[i];
        }
        int changedVariables = changedStateVariables.size();
        if (!unknownResults && updatedRows != changedVariables) {
            throw new IllegalStateException("Failed to insert/update state variables, expected update count " + changedVariables + ", actual " + updatedRows);
        }
    }

    public void updateWorkflowInstanceAfterExecution(WorkflowInstance instance, WorkflowInstanceAction action, List<WorkflowInstance> childWorkflows, List<WorkflowInstance> workflows, boolean createAction) {
        Assert.isTrue((action != null ? 1 : 0) != 0, (String)"action can not be null");
        Assert.isTrue((childWorkflows != null ? 1 : 0) != 0, (String)"childWorkflows can not be null");
        Assert.isTrue((workflows != null ? 1 : 0) != 0, (String)"workflows can not be null");
        Map<String, String> changedStateVariables = instance.getChangedStateVariables();
        if (!(createAction || childWorkflows.isEmpty() && workflows.isEmpty() && changedStateVariables.isEmpty())) {
            logger.info("Forcing action creation because new workflow instances are created or state variables are changed.");
            createAction = true;
        }
        if (createAction) {
            if (this.sqlVariants.hasUpdateableCTE() && childWorkflows.isEmpty() && workflows.isEmpty()) {
                this.updateWorkflowInstanceWithCTE(instance, action, changedStateVariables);
            } else {
                this.updateWorkflowInstanceWithTransaction(instance, action, childWorkflows, workflows, changedStateVariables);
            }
        } else {
            this.updateWorkflowInstance(instance);
        }
    }

    public int updateWorkflowInstance(WorkflowInstance instance) {
        Object nextActivation = this.sqlVariants.toTimestampObject(instance.nextActivation);
        int updated = this.jdbc.update(this.updateWorkflowInstanceSql(), new Object[]{instance.status.name(), instance.state, org.apache.commons.lang3.StringUtils.abbreviate((String)instance.stateText, (int)this.getInstanceStateTextLength()), nextActivation, nextActivation, nextActivation, instance.status == WorkflowInstance.WorkflowInstanceStatus.executing ? Integer.valueOf(this.executorInfo.getExecutorId()) : null, instance.retries, instance.businessKey, DaoUtil.toTimestamp((BaseDateTime)instance.started), instance.id});
        if (updated == 0) {
            logger.warn("Updating workflow instance {} did not update any rows in the database, instance may have been recovered by another executor.", (Object)instance.id);
        }
        return updated;
    }

    private void updateWorkflowInstanceWithTransaction(final WorkflowInstance instance, final WorkflowInstanceAction action, final List<WorkflowInstance> childWorkflows, final List<WorkflowInstance> workflows, final Map<String, String> changedStateVariables) {
        this.transaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                int updated = WorkflowInstanceDao.this.updateWorkflowInstance(instance);
                if (updated == 0) {
                    return;
                }
                long parentActionId = WorkflowInstanceDao.this.insertWorkflowInstanceAction(action);
                WorkflowInstanceDao.this.insertVariables(action.workflowInstanceId, parentActionId, changedStateVariables);
                for (WorkflowInstance childTemplate : childWorkflows) {
                    WorkflowInstance childWorkflow = new WorkflowInstance.Builder(childTemplate).setParentWorkflowId(instance.id).setParentActionId(parentActionId).build();
                    WorkflowInstanceDao.this.insertWorkflowInstance(childWorkflow);
                }
                for (WorkflowInstance workflow : workflows) {
                    WorkflowInstanceDao.this.insertWorkflowInstance(workflow);
                }
            }
        });
    }

    public void recoverWorkflowInstancesFromDeadNodes() {
        Collection<Integer> recoverableExecutorIds = this.executorInfo.getRecoverableExecutorIds();
        if (recoverableExecutorIds.isEmpty()) {
            return;
        }
        WorkflowInstanceAction.Builder builder = new WorkflowInstanceAction.Builder().setExecutionStart(DateTime.now()).setExecutionEnd(DateTime.now()).setType(WorkflowInstanceAction.WorkflowActionType.recovery).setStateText("Recovered");
        for (InstanceInfo instance : this.getRecoverableWorkflowInstances(recoverableExecutorIds)) {
            WorkflowInstanceAction action = builder.setState(instance.state).setWorkflowInstanceId(instance.id).build();
            this.recoverWorkflowInstance(instance.id, instance.executorId, action);
        }
        recoverableExecutorIds.forEach(this.executorInfo::markRecovered);
    }

    private List<InstanceInfo> getRecoverableWorkflowInstances(Collection<Integer> executorsIds) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("select id, executor_id, state from nflow_workflow where executor_id in (");
        executorsIds.forEach(id -> sql.append("?,"));
        sql.setCharAt(sql.length() - 1, ')');
        return this.jdbc.query(sql.toString(), (rs, rowNum) -> {
            InstanceInfo instance = new InstanceInfo();
            instance.id = rs.getLong(1);
            instance.executorId = rs.getInt(2);
            instance.state = rs.getString(3);
            return instance;
        }, (Object[])executorsIds.toArray(new Integer[0]));
    }

    private void recoverWorkflowInstance(long instanceId, int expectedExecutorId, WorkflowInstanceAction action) {
        this.transaction.execute(status -> {
            int updated = this.jdbc.update("update nflow_workflow set executor_id = null, status = " + this.sqlVariants.workflowStatus(WorkflowInstance.WorkflowInstanceStatus.inProgress) + " where id = ? and executor_id = ?", new Object[]{instanceId, expectedExecutorId});
            if (updated > 0) {
                this.insertWorkflowInstanceAction(action);
            }
            return null;
        });
    }

    private void updateWorkflowInstanceWithCTE(WorkflowInstance instance, WorkflowInstanceAction action, Map<String, String> changedStateVariables) {
        int executorId = this.executorInfo.getExecutorId();
        StringBuilder sqlb = new StringBuilder(256);
        sqlb.append("with wf as (").append(this.updateWorkflowInstanceSql()).append(" returning id), ");
        sqlb.append("act as (").append(this.insertWorkflowActionSql()).append(" select wf.id, ?, ").append(this.sqlVariants.actionType()).append(", ?, ?, ?, ?, ? from wf returning id)");
        Timestamp nextActivation = DaoUtil.toTimestamp((BaseDateTime)instance.nextActivation);
        Object[] fixedValues = new Object[]{instance.status.name(), instance.state, org.apache.commons.lang3.StringUtils.abbreviate((String)instance.stateText, (int)this.getInstanceStateTextLength()), nextActivation, nextActivation, nextActivation, instance.status == WorkflowInstance.WorkflowInstanceStatus.executing ? Integer.valueOf(executorId) : null, instance.retries, instance.businessKey, DaoUtil.toTimestamp((BaseDateTime)action.executionStart), instance.id, executorId, action.type.name(), action.state, org.apache.commons.lang3.StringUtils.abbreviate((String)action.stateText, (int)this.getActionStateTextLength()), action.retryNo, DaoUtil.toTimestamp((BaseDateTime)action.executionStart), DaoUtil.toTimestamp((BaseDateTime)action.executionEnd)};
        int pos = fixedValues.length;
        Object[] args = Arrays.copyOf(fixedValues, pos + changedStateVariables.size() * 2);
        for (Map.Entry<String, String> variable : changedStateVariables.entrySet()) {
            sqlb.append(", ins").append(pos).append(" as (").append(this.insertWorkflowInstanceStateSql()).append(" select wf.id,act.id,?,? from wf,act)");
            args[pos++] = variable.getKey();
            args[pos++] = variable.getValue();
        }
        sqlb.append(" select act.id from act");
        Long result = (Long)this.jdbc.queryForObject(sqlb.toString(), Long.class, args);
        if (result == null) {
            logger.warn("Updating workflow instance {} returned null, instance may have been recovered by another executor.", (Object)instance.id);
        }
    }

    public void checkStateVariableValueLength(String name, String value) {
        int maxLength = this.getStateVariableValueMaxLength();
        if (org.apache.commons.lang3.StringUtils.length((CharSequence)value) > maxLength) {
            throw new StateVariableValueTooLongException("Too long value (length = " + org.apache.commons.lang3.StringUtils.length((CharSequence)value) + ") for state variable " + name + ": maximum allowed length is " + maxLength);
        }
    }

    String insertWorkflowActionSql() {
        return "insert into nflow_workflow_action(workflow_id, executor_id, type, state, state_text, retry_no, execution_start, execution_end)";
    }

    private String updateWorkflowInstanceSql() {
        return "update nflow_workflow set status = " + this.sqlVariants.workflowStatus() + ", state = ?, state_text = ?, next_activation = " + this.sqlVariants.nextActivationUpdate() + ", external_next_activation = null, executor_id = ?, retries = ?, business_key = ?, started = (case when started is null then ? else started end) where id = ? and executor_id = " + this.executorInfo.getExecutorId();
    }

    public boolean updateNotRunningWorkflowInstance(WorkflowInstance instance) {
        ArrayList<Object> vars = new ArrayList<Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        if (instance.state != null) {
            vars.add("state = ?, retries = 0");
            args.add(instance.state);
        }
        if (instance.stateText != null) {
            vars.add("state_text = ?");
            args.add(instance.stateText);
        }
        if (instance.nextActivation != null) {
            vars.add("next_activation = ?");
            args.add(this.sqlVariants.toTimestampObject(instance.nextActivation));
        }
        if (instance.status != null) {
            vars.add("status = " + this.sqlVariants.workflowStatus());
            args.add(instance.status.name());
        }
        if (instance.businessKey != null) {
            vars.add("business_key = ?");
            args.add(instance.businessKey);
        }
        String sql = "update nflow_workflow set " + org.apache.commons.lang3.StringUtils.join(vars, (String)", ") + " where id = ? and executor_id is null";
        args.add(instance.id);
        return this.jdbc.update(sql, args.toArray()) == 1;
    }

    public boolean wakeUpWorkflowExternally(long workflowInstanceId, List<String> expectedStates) {
        StringBuilder sql = new StringBuilder("update nflow_workflow set next_activation = (case when executor_id is null then ").append("case when ").append(this.sqlVariants.dateLtEqDiff("next_activation", "current_timestamp")).append(" then next_activation else current_timestamp end else next_activation end), ").append("external_next_activation = current_timestamp where ").append(this.executorInfo.getExecutorGroupCondition()).append(" and id = ? and next_activation is not null");
        return this.addExpectedStatesToQueryAndUpdate(sql, workflowInstanceId, expectedStates);
    }

    public boolean wakeupWorkflowInstanceIfNotExecuting(long workflowInstanceId, List<String> expectedStates) {
        StringBuilder sql = new StringBuilder("update nflow_workflow set next_activation = current_timestamp").append(" where id = ? and executor_id is null and status in (").append(this.sqlVariants.workflowStatus(WorkflowInstance.WorkflowInstanceStatus.inProgress)).append(", ").append(this.sqlVariants.workflowStatus(WorkflowInstance.WorkflowInstanceStatus.created)).append(") and (next_activation is null or next_activation > current_timestamp)");
        return this.addExpectedStatesToQueryAndUpdate(sql, workflowInstanceId, expectedStates);
    }

    private boolean addExpectedStatesToQueryAndUpdate(StringBuilder sql, long workflowInstanceId, List<String> expectedStates) {
        Object[] args = new Object[1 + expectedStates.size()];
        args[0] = workflowInstanceId;
        if (!expectedStates.isEmpty()) {
            sql.append(" and state in (");
            for (int i = 0; i < expectedStates.size(); ++i) {
                sql.append("?,");
                args[i + 1] = expectedStates.get(i);
            }
            sql.setCharAt(sql.length() - 1, ')');
        }
        return this.jdbc.update(sql.toString(), args) == 1;
    }

    public WorkflowInstance getWorkflowInstance(long id, Set<WorkflowInstanceInclude> includes, Long maxActions, boolean queryArchive) {
        String sql = "select id, executor_id, parent_workflow_id, parent_action_id, status, type, priority, business_key, external_id, state, state_text, next_activation, retries, created, modified, started, executor_group, workflow_signal, 0 as archived from " + NflowTable.WORKFLOW.main + " where id = ?";
        Object[] args = new Object[]{id};
        if (queryArchive) {
            sql = sql + " union all select id, executor_id, parent_workflow_id, parent_action_id, status, type, priority, business_key, external_id, state, state_text, next_activation, retries, created, modified, started, executor_group, workflow_signal, 1 as archived from " + NflowTable.WORKFLOW.archive + " where id = ?";
            args = new Object[]{id, id};
        }
        WorkflowInstance instance = ((WorkflowInstance.Builder)this.jdbc.queryForObject(sql, (RowMapper)this.workflowInstanceRowMapper, args)).build();
        if (includes.contains((Object)WorkflowInstanceInclude.CURRENT_STATE_VARIABLES)) {
            this.fillState(instance);
        }
        if (includes.contains((Object)WorkflowInstanceInclude.CHILD_WORKFLOW_IDS)) {
            this.fillChildWorkflowIds(instance, queryArchive);
        }
        if (includes.contains((Object)WorkflowInstanceInclude.ACTIONS)) {
            this.fillActions(instance, includes.contains((Object)WorkflowInstanceInclude.ACTION_STATE_VARIABLES), maxActions);
        }
        return instance;
    }

    private void fillState(WorkflowInstance instance) {
        String tableName = NflowTable.STATE.tableFor(instance);
        this.jdbc.query("select outside.state_key, outside.state_value from " + tableName + " outside inner join (select workflow_id, max(action_id) action_id, state_key from " + tableName + " where workflow_id = ? group by workflow_id, state_key) inside on outside.workflow_id = inside.workflow_id and outside.action_id = inside.action_id and outside.state_key = inside.state_key", rs -> instance.stateVariables.put(rs.getString(1), rs.getString(2)), new Object[]{instance.id});
        instance.originalStateVariables.putAll(instance.stateVariables);
    }

    public List<Long> pollNextWorkflowInstanceIds(int batchSize) {
        if (this.sqlVariants.hasUpdateReturning()) {
            return this.pollNextWorkflowInstanceIdsWithUpdateReturning(batchSize);
        }
        return this.pollNextWorkflowInstanceIdsWithTransaction(batchSize);
    }

    String updateInstanceForExecutionQuery() {
        return "update nflow_workflow set executor_id = " + this.executorInfo.getExecutorId() + ", status = " + this.sqlVariants.workflowStatus(WorkflowInstance.WorkflowInstanceStatus.executing) + ", external_next_activation = null";
    }

    String whereConditionForInstanceUpdate() {
        return "where executor_id is null and status in (" + this.sqlVariants.workflowStatus(WorkflowInstance.WorkflowInstanceStatus.created) + ", " + this.sqlVariants.workflowStatus(WorkflowInstance.WorkflowInstanceStatus.inProgress) + ") and " + this.sqlVariants.dateLtEqDiff("next_activation", "current_timestamp") + " and " + this.executorInfo.getExecutorGroupCondition() + " order by priority desc, next_activation asc";
    }

    private List<Long> pollNextWorkflowInstanceIdsWithUpdateReturning(int batchSize) {
        String sql = this.updateInstanceForExecutionQuery() + " where id in (" + this.sqlVariants.limit("select id from nflow_workflow " + this.sqlVariants.withUpdateSkipLocked() + this.whereConditionForInstanceUpdate(), batchSize) + this.sqlVariants.forUpdateSkipLocked() + ") and executor_id is null returning id";
        List ids = this.jdbc.queryForList(sql, Long.class);
        if (ids.size() > batchSize) {
            logger.warn("Got too many workflow instances {} > {}", (Object)ids.size(), (Object)batchSize);
            List<Long> extras = ids.subList(batchSize, ids.size());
            this.clearExecutorId(extras);
            ids = ids.subList(0, batchSize);
        }
        return ids;
    }

    public void clearExecutorId(List<Long> workflowInstances) {
        this.jdbc.update("update nflow_workflow set executor_id=null, status = " + this.sqlVariants.workflowStatus(WorkflowInstance.WorkflowInstanceStatus.inProgress) + " where executor_id = " + this.executorInfo.getExecutorId() + " and id in (" + workflowInstances.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")");
    }

    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="PollingRaceConditionException message is ok")
    private List<Long> pollNextWorkflowInstanceIdsWithTransaction(int batchSize) {
        String sql = this.sqlVariants.limit("select id, modified from nflow_workflow " + this.whereConditionForInstanceUpdate(), batchSize);
        List instances = (List)this.transaction.execute(tx -> this.jdbc.query(sql, (rs, rowNum) -> new OptimisticLockKey(rs.getLong("id"), this.sqlVariants.getTimestamp(rs, "modified"))));
        if (instances.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(instances);
        List ids = (List)this.transaction.execute(transactionStatus -> {
            if (this.useBatchUpdate()) {
                return this.updateNextWorkflowInstancesWithBatchUpdate(instances);
            }
            return this.updateNextWorkflowInstancesWithMultipleUpdates(instances);
        });
        if (ids.isEmpty()) {
            throw new PollingRaceConditionException("None of the workflow instances selected for processing were successfully reserved for this executor, trying again later.");
        }
        return ids;
    }

    private List<Long> updateNextWorkflowInstancesWithMultipleUpdates(Collection<OptimisticLockKey> instances) {
        String sql = this.updateInstanceForExecutionQuery() + " where id = ? and modified = ? and executor_id is null";
        return instances.stream().flatMap(instance -> this.jdbc.update(sql, new Object[]{instance.id, this.sqlVariants.tuneTimestampForDb(instance.modified)}) == 1 ? Stream.of(Long.valueOf(instance.id)) : Stream.empty()).collect(Collectors.toList());
    }

    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="PollingBatchException message is ok")
    private List<Long> updateNextWorkflowInstancesWithBatchUpdate(List<OptimisticLockKey> instances) {
        String sql = this.updateInstanceForExecutionQuery() + " where id = ? and modified = ? and executor_id is null";
        List batchArgs = instances.stream().map(instance -> new Object[]{instance.id, this.sqlVariants.tuneTimestampForDb(instance.modified)}).collect(Collectors.toList());
        int[] updateStatuses = this.jdbc.batchUpdate(sql, batchArgs);
        ArrayList<Long> ids = new ArrayList<Long>(instances.size());
        for (int i = 0; i < updateStatuses.length; ++i) {
            int status = updateStatuses[i];
            if (status == 1) {
                ids.add(instances.get((int)i).id);
                continue;
            }
            if (status == 0) continue;
            this.disableBatchUpdates.set(true);
            throw new PollingBatchException("Database was unable to provide information about affected rows in a batch update. Disabling batch updates.");
        }
        return ids;
    }

    public List<WorkflowInstance> queryWorkflowInstances(QueryWorkflowInstances query) {
        return this.queryWorkflowInstancesAsStream(query).collect(Collectors.toList());
    }

    public Stream<WorkflowInstance> queryWorkflowInstancesAsStream(QueryWorkflowInstances query) {
        ArrayList<String> conditions = new ArrayList<String>();
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.queryOptionsToSqlAndParams(query, conditions, params);
        conditions.add(this.executorInfo.getExecutorGroupCondition());
        Object sqlSuffix = "from nflow_workflow wf ";
        if (query.stateVariableKey != null) {
            sqlSuffix = (String)sqlSuffix + "inner join nflow_workflow_state wfs on wf.id = wfs.workflow_id and wfs.state_key = :state_key and " + this.sqlVariants.clobToComparable("wfs.state_value") + " = :state_value ";
            conditions.add("wfs.action_id = (select max(action_id) from nflow_workflow_state where workflow_id = wf.id and state_key = :state_key)");
            params.addValue("state_key", (Object)query.stateVariableKey);
            params.addValue("state_value", (Object)query.stateVariableValue);
        }
        sqlSuffix = (String)sqlSuffix + "where " + StringUtils.collectionToDelimitedString(conditions, (String)" and ") + " order by id desc";
        long maxResults = this.getMaxResults(query.maxResults);
        String sql = this.sqlVariants.limit("select id, executor_id, parent_workflow_id, parent_action_id, status, type, priority, business_key, external_id, state, state_text, next_activation, retries, created, modified, started, executor_group, workflow_signal, 0 as archived " + (String)sqlSuffix, maxResults);
        List results = this.namedJdbc.query(sql, (SqlParameterSource)params, (RowMapper)this.workflowInstanceRowMapper);
        Stream resultStream = results.stream();
        if (query.queryArchive && (maxResults -= (long)results.size()) > 0L) {
            sql = this.sqlVariants.limit("select id, executor_id, parent_workflow_id, parent_action_id, status, type, priority, business_key, external_id, state, state_text, next_activation, retries, created, modified, started, executor_group, workflow_signal, 1 as archived " + TableType.convertMainToArchive((String)sqlSuffix), maxResults);
            resultStream = Stream.concat(resultStream, this.namedJdbc.query(sql, (SqlParameterSource)params, (RowMapper)this.workflowInstanceRowMapper).stream());
        }
        Stream<WorkflowInstance> ret = resultStream.map(WorkflowInstance.Builder::build);
        if (query.includeCurrentStateVariables) {
            ret = ret.peek(instance -> this.fillState((WorkflowInstance)instance));
        }
        if (query.includeActions) {
            ret = ret.peek(instance -> this.fillActions((WorkflowInstance)instance, query.includeActionStateVariables, query.maxActions));
        }
        if (query.includeChildWorkflows) {
            ret = ret.peek(instance -> this.fillChildWorkflowIds((WorkflowInstance)instance, query.queryArchive));
        }
        return ret;
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"}, justification="businessKey and externalId are strings")
    private void queryOptionsToSqlAndParams(QueryWorkflowInstances query, List<String> conditions, MapSqlParameterSource params) {
        if (!CollectionUtils.isEmpty(query.ids)) {
            if (query.ids.size() == 1) {
                conditions.add("id = :id");
                params.addValue("id", (Object)query.ids.get(0));
            } else {
                conditions.add("id in (:ids)");
                params.addValue("ids", query.ids);
            }
        }
        if (!CollectionUtils.isEmpty(query.types)) {
            if (query.types.size() == 1) {
                conditions.add("type = :type");
                params.addValue("type", (Object)query.types.get(0));
            } else {
                conditions.add("type in (:types)");
                params.addValue("types", query.types);
            }
        }
        if (query.parentWorkflowId != null) {
            conditions.add("parent_workflow_id = :parent_workflow_id");
            params.addValue("parent_workflow_id", (Object)query.parentWorkflowId);
        }
        if (query.parentActionId != null) {
            conditions.add("parent_action_id = :parent_action_id");
            params.addValue("parent_action_id", (Object)query.parentActionId);
        }
        if (!CollectionUtils.isEmpty(query.states)) {
            if (query.states.size() == 1) {
                conditions.add("state = :state");
                params.addValue("state", (Object)query.states.get(0));
            } else {
                conditions.add("state in (:states)");
                params.addValue("states", query.states);
            }
        }
        if (!CollectionUtils.isEmpty(query.statuses)) {
            List convertedStatuses = query.statuses.stream().map(Enum::name).collect(Collectors.toList());
            conditions.add("status" + this.sqlVariants.castToText() + " in (:statuses)");
            params.addValue("statuses", convertedStatuses);
        }
        if (query.businessKey != null) {
            if (query.businessKey.indexOf(37) >= 0) {
                conditions.add("business_key " + this.sqlVariants.caseSensitiveLike() + " :business_key");
            } else {
                conditions.add("business_key = :business_key");
            }
            params.addValue("business_key", (Object)query.businessKey);
        }
        if (query.externalId != null) {
            if (query.externalId.indexOf(37) >= 0) {
                conditions.add("external_id " + this.sqlVariants.caseSensitiveLike() + " :external_id");
            } else {
                conditions.add("external_id = :external_id");
            }
            params.addValue("external_id", (Object)query.externalId);
        }
    }

    private void fillChildWorkflowIds(WorkflowInstance instance, boolean queryArchive) {
        Object[] objectArray;
        Stream<String> tables = queryArchive ? Stream.of(NflowTable.WORKFLOW.main, NflowTable.WORKFLOW.archive) : Stream.of(NflowTable.WORKFLOW.main);
        String sql = tables.map(table -> "select parent_action_id, id from " + table + " where parent_workflow_id = ?").collect(Collectors.joining(" union all "));
        if (queryArchive) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = instance.id;
            objectArray = objectArray2;
            objectArray2[1] = instance.id;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = instance.id;
        }
        Object[] args = objectArray;
        this.jdbc.query(sql, rs -> {
            long parentActionId = rs.getLong(1);
            long childWorkflowInstanceId = rs.getLong(2);
            List children = instance.childWorkflows.computeIfAbsent(parentActionId, k -> new ArrayList());
            children.add(childWorkflowInstanceId);
        }, args);
    }

    private long getMaxResults(Long maxResults) {
        if (maxResults == null) {
            return this.workflowInstanceQueryMaxResultsDefault;
        }
        return Math.min(maxResults, this.workflowInstanceQueryMaxResults);
    }

    private void fillActions(WorkflowInstance instance, boolean includeStateVariables, Long requestedMaxActions) {
        long maxActions = this.getMaxActions(requestedMaxActions);
        String tableName = NflowTable.ACTION.tableFor(instance);
        String sql = this.sqlVariants.limit("select * from " + tableName + " where workflow_id = ? order by id desc", maxActions);
        List actionBuilders = this.jdbc.query(sql, (RowMapper)this.workflowInstanceActionRowMapper, new Object[]{instance.id});
        if (includeStateVariables) {
            Map<Long, Map<String, String>> actionStates = this.fetchActionStateVariables(instance, actionBuilders.size(), maxActions);
            actionBuilders.forEach(builder -> {
                Map actionState = (Map)actionStates.get(builder.getId());
                if (actionState != null) {
                    builder.setUpdatedStateVariables(actionState);
                }
            });
        }
        actionBuilders.stream().map(WorkflowInstanceAction.Builder::build).forEach(instance.actions::add);
    }

    private long getMaxActions(Long maxActions) {
        if (maxActions == null) {
            return this.workflowInstanceQueryMaxActionsDefault;
        }
        return Math.min(maxActions, this.workflowInstanceQueryMaxActions);
    }

    private Map<Long, Map<String, String>> fetchActionStateVariables(WorkflowInstance instance, long actions, long maxActions) {
        String stateTableName = NflowTable.STATE.tableFor(instance);
        String actionTableName = NflowTable.ACTION.tableFor(instance);
        if (actions < maxActions) {
            return (Map)this.jdbc.query("select * from " + stateTableName + " where workflow_id = ? order by action_id, state_key asc", (ResultSetExtractor)new WorkflowActionStateRowMapper(), new Object[]{instance.id});
        }
        return (Map)this.jdbc.query("select nflow_workflow_state.* from (" + this.sqlVariants.limit("select id from " + actionTableName + " nflow_workflow_action where workflow_id = ? order by id desc", maxActions) + ") action_id inner join " + stateTableName + " nflow_workflow_state on nflow_workflow_state.workflow_id = ? and action_id.id = nflow_workflow_state.action_id order by nflow_workflow_state.action_id, nflow_workflow_state.state_key asc", (ResultSetExtractor)new WorkflowActionStateRowMapper(), new Object[]{instance.id, instance.id});
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public long insertWorkflowInstanceAction(WorkflowInstance instance, WorkflowInstanceAction action) {
        long actionId = this.insertWorkflowInstanceAction(action);
        this.insertVariables(action.workflowInstanceId, actionId, instance.getChangedStateVariables());
        return actionId;
    }

    public long insertWorkflowInstanceAction(final WorkflowInstanceAction action) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbc.update(new PreparedStatementCreator(){

            @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="findbugs does not trust jdbctemplate, sql string is practically constant")
            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement p = con.prepareStatement(WorkflowInstanceDao.this.insertWorkflowActionSql() + " values (?, ?, " + WorkflowInstanceDao.this.sqlVariants.actionType() + ", ?, ?, ?, ?, ?)", new String[]{"id"});
                int field = 1;
                p.setLong(field++, action.workflowInstanceId);
                p.setInt(field++, WorkflowInstanceDao.this.executorInfo.getExecutorId());
                p.setString(field++, action.type.name());
                p.setString(field++, action.state);
                p.setString(field++, org.apache.commons.lang3.StringUtils.abbreviate((String)action.stateText, (int)WorkflowInstanceDao.this.getActionStateTextLength()));
                p.setInt(field++, action.retryNo);
                WorkflowInstanceDao.this.sqlVariants.setDateTime(p, field++, action.executionStart);
                WorkflowInstanceDao.this.sqlVariants.setDateTime(p, field++, action.executionEnd);
                return p;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    public String getWorkflowInstanceState(long workflowInstanceId) {
        return (String)this.jdbc.queryForObject("select state from nflow_workflow where id = ?", String.class, new Object[]{workflowInstanceId});
    }

    public Optional<Integer> getSignal(long workflowInstanceId) {
        return Optional.ofNullable((Integer)this.jdbc.queryForObject("select workflow_signal from nflow_workflow where id = ?", Integer.class, new Object[]{workflowInstanceId}));
    }

    @Transactional
    public boolean setSignal(long workflowInstanceId, Optional<Integer> signal, String reason, WorkflowInstanceAction.WorkflowActionType actionType) {
        boolean updated;
        boolean bl = updated = this.jdbc.update("update nflow_workflow set workflow_signal = ? where id = ?", new Object[]{signal.orElse(null), workflowInstanceId}) > 0;
        if (updated) {
            DateTime now = DateTime.now();
            WorkflowInstanceAction action = new WorkflowInstanceAction.Builder().setWorkflowInstanceId(workflowInstanceId).setExecutionStart(now).setExecutionEnd(now).setState(this.getWorkflowInstanceState(workflowInstanceId)).setStateText(reason).setType(actionType).build();
            this.insertWorkflowInstanceAction(action);
        }
        return updated;
    }

    public String getWorkflowInstanceType(long workflowInstanceId) {
        String type = this.workflowTypeByWorkflowIdCache.computeIfAbsent(workflowInstanceId, id -> ((String)this.jdbc.queryForObject("select type from nflow_workflow where id = ?", String.class, new Object[]{id})).intern());
        if (this.workflowTypeByWorkflowIdCache.size() > this.workflowInstanceTypeCacheSize) {
            this.workflowTypeByWorkflowIdCache.clear();
        }
        return type;
    }

    static class WorkflowInstanceRowMapper
    implements RowMapper<WorkflowInstance.Builder> {
        static final String ALL_WORKFLOW_COLUMNS = "id, executor_id, parent_workflow_id, parent_action_id, status, type, priority, business_key, external_id, state, state_text, next_activation, retries, created, modified, started, executor_group, workflow_signal";
        private final SQLVariants sqlVariants;
        private final WorkflowInstanceFactory workflowInstanceFactory;

        public WorkflowInstanceRowMapper(SQLVariants sqlVariants, WorkflowInstanceFactory workflowInstanceFactory) {
            this.sqlVariants = sqlVariants;
            this.workflowInstanceFactory = workflowInstanceFactory;
        }

        public WorkflowInstance.Builder mapRow(ResultSet rs, int rowNum) throws SQLException {
            return this.workflowInstanceFactory.newWorkflowInstanceBuilder().setId(rs.getLong("id")).setExecutorId(DaoUtil.getInt(rs, "executor_id")).setParentWorkflowId(DaoUtil.getLong(rs, "parent_workflow_id")).setParentActionId(DaoUtil.getLong(rs, "parent_action_id")).setStatus(WorkflowInstance.WorkflowInstanceStatus.valueOf(rs.getString("status"))).setType(rs.getString("type")).setPriority(rs.getShort("priority")).setBusinessKey(rs.getString("business_key")).setExternalId(rs.getString("external_id")).setState(rs.getString("state")).setStateText(rs.getString("state_text")).setActions(new ArrayList<WorkflowInstanceAction>()).setNextActivation(this.sqlVariants.getDateTime(rs, "next_activation")).setRetries(rs.getInt("retries")).setCreated(this.sqlVariants.getDateTime(rs, "created")).setModified(this.sqlVariants.getDateTime(rs, "modified")).setStartedIfNotSet(this.sqlVariants.getDateTime(rs, "started")).setExecutorGroup(rs.getString("executor_group")).setSignal(Optional.ofNullable(DaoUtil.getInt(rs, "workflow_signal"))).setArchived(rs.getBoolean("archived"));
        }
    }

    static class WorkflowInstanceActionRowMapper
    implements RowMapper<WorkflowInstanceAction.Builder> {
        private final SQLVariants sqlVariants;

        public WorkflowInstanceActionRowMapper(SQLVariants sqlVariants) {
            this.sqlVariants = sqlVariants;
        }

        public WorkflowInstanceAction.Builder mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new WorkflowInstanceAction.Builder().setId(rs.getLong("id")).setWorkflowInstanceId(rs.getLong("workflow_id")).setExecutorId(rs.getInt("executor_id")).setType(WorkflowInstanceAction.WorkflowActionType.valueOf(rs.getString("type"))).setState(rs.getString("state")).setStateText(rs.getString("state_text")).setRetryNo(rs.getInt("retry_no")).setExecutionStart(this.sqlVariants.getDateTime(rs, "execution_start")).setExecutionEnd(this.sqlVariants.getDateTime(rs, "execution_end"));
        }
    }

    private static class OptimisticLockKey
    extends ModelObject
    implements Comparable<OptimisticLockKey> {
        public final long id;
        public final Object modified;

        public OptimisticLockKey(long id, Object modified) {
            this.id = id;
            this.modified = modified;
        }

        @Override
        @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="This class has a natural ordering that is inconsistent with equals")
        public int compareTo(OptimisticLockKey other) {
            return Long.compare(this.id, other.id);
        }
    }

    static class WorkflowActionStateRowMapper
    implements ResultSetExtractor<Map<Long, Map<String, String>>> {
        private final Map<Long, Map<String, String>> actionStates = new LinkedHashMap<Long, Map<String, String>>();

        WorkflowActionStateRowMapper() {
        }

        public Map<Long, Map<String, String>> extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                long actionId = rs.getLong("action_id");
                String stateKey = rs.getString("state_key");
                String stateValue = rs.getString("state_value");
                this.actionStates.computeIfAbsent(actionId, k -> new LinkedHashMap()).put(stateKey, stateValue);
            }
            return this.actionStates;
        }
    }
}

