/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.workflow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.EngineConfiguration;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.workflow.WorkflowStateMethod;
import io.nflow.engine.workflow.definition.Mutable;
import io.nflow.engine.workflow.definition.StateExecution;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.springframework.stereotype.Component;

@Component
public class ObjectStringMapper {
    private final ObjectMapper mapper;

    @Inject
    public ObjectStringMapper(@NFlow EngineConfiguration.EngineObjectMapperSupplier nflowObjectMapper) {
        this.mapper = (ObjectMapper)nflowObjectMapper.get();
    }

    @SuppressFBWarnings(value={"UCC_UNRELATED_COLLECTION_CONTENTS"}, justification="args are unrelated")
    public Object[] createArguments(StateExecution execution, WorkflowStateMethod method) {
        Object[] args = new Object[method.params.length + 1];
        args[0] = execution;
        WorkflowStateMethod.StateParameter[] params = method.params;
        for (int i = 1; i <= params.length; ++i) {
            WorkflowStateMethod.StateParameter param = params[i - 1];
            String value = execution.getVariable(param.key);
            if (value == null) {
                Object def = param.nullValue;
                if (def instanceof Constructor) {
                    try {
                        def = ((Constructor)def).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException("Failed to instantiate default value for " + param.key, e);
                    }
                }
                args[i] = def;
            } else {
                args[i] = String.class.equals((Object)param.type) ? value : this.convertToObject(param.type, param.key, value);
            }
            if (!param.mutable) continue;
            args[i] = new Mutable<Object>(args[i]);
        }
        return args;
    }

    public Object convertToObject(Type type, String key, String value) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        try {
            return this.mapper.readValue(value, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize value for " + key, e);
        }
    }

    public void storeArguments(StateExecution execution, WorkflowStateMethod method, Object[] args) {
        WorkflowStateMethod.StateParameter[] params = method.params;
        for (int i = 0; i < params.length; ++i) {
            Object value;
            WorkflowStateMethod.StateParameter param = params[i];
            if (param.readOnly || (value = args[i + 1]) == null || param.mutable && (value = ((Mutable)value).val) == null) continue;
            String sVal = String.class.equals((Object)param.type) ? (String)value : this.convertFromObject(param.key, value);
            execution.setVariable(param.key, sVal);
        }
    }

    public String convertFromObject(String key, Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize value for " + key, e);
        }
    }
}

