/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.workflow;

import io.nflow.engine.internal.workflow.StoredWorkflowDefinition;
import io.nflow.engine.workflow.curated.State;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class StoredWorkflowDefinitionWrapper
extends WorkflowDefinition {
    public StoredWorkflowDefinitionWrapper(StoredWorkflowDefinition stored) {
        super(stored.type, StoredWorkflowDefinitionWrapper.getInitialState(stored), StoredWorkflowDefinitionWrapper.getErrorState(stored), new WorkflowSettings.Builder().build(), Collections.emptyMap(), StoredWorkflowDefinitionWrapper.allStates(stored), false);
        this.setDescription(stored.description);
    }

    private static Collection<WorkflowState> allStates(StoredWorkflowDefinition stored) {
        return stored.states.stream().map(StoredWorkflowDefinitionWrapper::toState).collect(Collectors.toList());
    }

    private static WorkflowState getInitialState(StoredWorkflowDefinition stored) {
        return stored.states.stream().filter(state -> WorkflowStateType.start.name().equals(state.type)).findFirst().map(StoredWorkflowDefinitionWrapper::toState).orElseThrow(() -> new IllegalStateException("Could not find initial state for " + stored));
    }

    private static WorkflowState toState(StoredWorkflowDefinition.State state) {
        return new State(state.id, WorkflowStateType.valueOf(state.type), state.description);
    }

    private static WorkflowState getErrorState(StoredWorkflowDefinition stored) {
        return stored.states.stream().filter(state -> stored.onError.equals(state.id)).findFirst().map(StoredWorkflowDefinitionWrapper::toState).orElseThrow(() -> new IllegalStateException("Could not find error state for " + stored));
    }
}

