/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.listener;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.listener.ListenerChain;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.StateExecution;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public interface WorkflowExecutorListener {
    default public void beforeProcessing(ListenerContext listenerContext) {
    }

    default public NextAction process(ListenerContext listenerContext, ListenerChain chain) {
        return chain.next(listenerContext);
    }

    default public void afterProcessing(ListenerContext listenerContext) {
    }

    default public void afterFailure(ListenerContext listenerContext, Throwable throwable) {
    }

    default public boolean handlePotentiallyStuck(ListenerContext listenerContext, Duration processingTime) {
        return false;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="listeners are implemented by business applications")
    public static class ListenerContext
    extends ModelObject {
        public final DateTime start = DateTime.now();
        public final WorkflowDefinition definition;
        public final String originalState;
        public final WorkflowInstance instance;
        public final StateExecution stateExecution;
        public NextAction nextAction = null;
        public final Map<Object, Object> data = new LinkedHashMap<Object, Object>();

        public ListenerContext(WorkflowDefinition definition, WorkflowInstance instance, StateExecution stateExecution) {
            this.definition = definition;
            this.instance = instance;
            this.stateExecution = stateExecution;
            this.originalState = instance.state;
        }
    }
}

