/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.dao.WorkflowDefinitionDao;
import io.nflow.engine.internal.workflow.StoredWorkflowDefinition;
import io.nflow.engine.internal.workflow.StoredWorkflowDefinitionWrapper;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Singleton
public class WorkflowDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionService.class);
    private final Map<String, WorkflowDefinition> workflowDefinitions = Collections.synchronizedMap(new LinkedHashMap());
    private List<WorkflowDefinition> workflowDefinitionValues = Collections.emptyList();
    private final WorkflowDefinitionDao workflowDefinitionDao;
    private final boolean persistWorkflowDefinitions;
    private final boolean autoInit;
    private final long storedDefinitionCheckInterval;
    private long nextCheckOfStoredDefinitions;

    @Inject
    public WorkflowDefinitionService(WorkflowDefinitionDao workflowDefinitionDao, Environment env) {
        this.workflowDefinitionDao = workflowDefinitionDao;
        this.persistWorkflowDefinitions = (Boolean)env.getRequiredProperty("nflow.definition.persist", Boolean.class);
        this.autoInit = (Boolean)env.getRequiredProperty("nflow.autoinit", Boolean.class);
        this.storedDefinitionCheckInterval = TimeUnit.SECONDS.toMillis(((Integer)env.getRequiredProperty("nflow.definition.refreshStoredFromDatabase.interval.seconds", Integer.class)).intValue());
        this.nextCheckOfStoredDefinitions = this.storedDefinitionCheckInterval > 0L ? 0L : Long.MAX_VALUE;
    }

    public WorkflowDefinition getWorkflowDefinition(String type) {
        WorkflowDefinition definition = this.workflowDefinitions.get(type);
        if (definition instanceof StoredWorkflowDefinitionWrapper && this.getWorkflowDefinitionRefreshTime() > 0L) {
            definition = null;
        }
        if (definition == null && this.refreshStoredDefinitions()) {
            definition = this.workflowDefinitions.get(type);
        }
        return definition;
    }

    public List<WorkflowDefinition> getWorkflowDefinitions() {
        this.refreshStoredDefinitions();
        return this.workflowDefinitionValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessWorkflowDefinitions() {
        if (!this.autoInit && this.persistWorkflowDefinitions) {
            Map<String, WorkflowDefinition> map = this.workflowDefinitions;
            synchronized (map) {
                this.workflowDefinitions.values().forEach(this.workflowDefinitionDao::storeWorkflowDefinition);
            }
        }
    }

    public void addWorkflowDefinition(WorkflowDefinition wd) {
        WorkflowDefinition conflict = this.workflowDefinitions.put(wd.getType(), wd);
        if (conflict != null) {
            throw new IllegalStateException("Both " + wd.getClass().getName() + " and " + conflict.getClass().getName() + " define same workflow type: " + wd.getType());
        }
        if (this.autoInit && this.persistWorkflowDefinitions) {
            this.workflowDefinitionDao.storeWorkflowDefinition(wd);
        }
        this.setWorkflowDefinitions(this.workflowDefinitions.values());
        logger.info("Added workflow type: {} ({})", (Object)wd.getType(), (Object)wd.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkflowDefinitions(Collection<WorkflowDefinition> newDefinitions) {
        Map<String, WorkflowDefinition> map = this.workflowDefinitions;
        synchronized (map) {
            this.workflowDefinitionValues = Collections.unmodifiableList(new ArrayList<WorkflowDefinition>(newDefinitions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"}, justification="synchronize(this) is valid and needed to match the below synchronized refreshStoredDefinitions() method")
    private long getWorkflowDefinitionRefreshTime() {
        if (this.storedDefinitionCheckInterval <= 0L) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        WorkflowDefinitionService workflowDefinitionService = this;
        synchronized (workflowDefinitionService) {
            if (this.nextCheckOfStoredDefinitions <= now) {
                return now;
            }
        }
        return -1L;
    }

    private synchronized boolean refreshStoredDefinitions() {
        long now = this.getWorkflowDefinitionRefreshTime();
        if (now <= -1L) {
            return false;
        }
        this.nextCheckOfStoredDefinitions = now + this.storedDefinitionCheckInterval;
        boolean changed = false;
        for (StoredWorkflowDefinition def : this.workflowDefinitionDao.queryStoredWorkflowDefinitions(Collections.emptyList())) {
            WorkflowDefinition current = this.workflowDefinitions.get(def.type);
            if (current != null && !(current instanceof StoredWorkflowDefinitionWrapper)) continue;
            StoredWorkflowDefinitionWrapper wrapper = new StoredWorkflowDefinitionWrapper(def);
            this.workflowDefinitions.put(def.type, wrapper);
            changed = true;
        }
        if (changed) {
            this.setWorkflowDefinitions(this.workflowDefinitions.values());
        }
        return changed;
    }
}

