/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.config.jaxrs;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

@Provider
public class DateTimeParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> type, Type genericType, Annotation[] annotations) {
        if (type.equals(DateTime.class)) {
            return new DateTimeParamConverter();
        }
        return null;
    }

    static final class DateTimeParamConverter
    implements ParamConverter<DateTime> {
        DateTimeParamConverter() {
        }

        public DateTime fromString(String value) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            try {
                return ISODateTimeFormat.dateTimeNoMillis().parseDateTime(value);
            }
            catch (IllegalArgumentException e) {
                try {
                    return ISODateTimeFormat.dateTime().parseDateTime(value);
                }
                catch (IllegalArgumentException e2) {
                    throw new BadRequestException(String.format("Unrecognized date format: %s", value), (Throwable)e2);
                }
            }
        }

        public String toString(DateTime value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }
}

