/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import io.nflow.engine.service.StatisticsService;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.converter.StatisticsConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.StatisticsResponse;
import io.nflow.rest.v1.msg.WorkflowDefinitionStatisticsResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Path(value="/v1/statistics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@NflowCors
@Tag(name="nFlow statistics")
public class StatisticsResource
extends JaxRsResource {
    @Inject
    private StatisticsService statisticsService;
    @Inject
    private StatisticsConverter statisticsConverter;

    @GET
    @Operation(summary="Get executor group statistics", description="Returns counts of queued and executing workflow instances.")
    @ApiResponse(responseCode="200", description="Statistics", content={@Content(schema=@Schema(implementation=StatisticsResponse.class))})
    public Response queryStatistics() {
        return this.handleExceptions(() -> Response.ok((Object)this.statisticsConverter.convert(this.statisticsService.getStatistics())));
    }

    @GET
    @Path(value="/workflow/{type}")
    @Operation(summary="Get workflow definition statistics")
    @ApiResponse(responseCode="200", description="Statistics", content={@Content(schema=@Schema(implementation=WorkflowDefinitionStatisticsResponse.class))})
    public Response getStatistics(@PathParam(value="type") @Parameter(description="Workflow definition type", required=true) String type, @QueryParam(value="createdAfter") @Parameter(description="Include only workflow instances created after given time") DateTime createdAfter, @QueryParam(value="createdBefore") @Parameter(description="Include only workflow instances created before given time") DateTime createdBefore, @QueryParam(value="modifiedAfter") @Parameter(description="Include only workflow instances modified after given time") DateTime modifiedAfter, @QueryParam(value="modifiedBefore") @Parameter(description="Include only workflow instances modified before given time") DateTime modifiedBefore) {
        return this.handleExceptions(() -> Response.ok((Object)this.statisticsConverter.convert(this.statisticsService.getWorkflowDefinitionStatistics(type, createdAfter, createdBefore, modifiedAfter, modifiedBefore))));
    }
}

