/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import io.nflow.engine.service.WorkflowExecutorService;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.converter.ListWorkflowExecutorConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.ListWorkflowExecutorResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Path(value="/v1/workflow-executor")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@NflowCors
@Tag(name="nFlow workflow executors")
public class WorkflowExecutorResource
extends JaxRsResource {
    private final WorkflowExecutorService workflowExecutors;
    private final ListWorkflowExecutorConverter converter;

    @Inject
    public WorkflowExecutorResource(WorkflowExecutorService workflowExecutors, ListWorkflowExecutorConverter converter) {
        this.workflowExecutors = workflowExecutors;
        this.converter = converter;
    }

    @GET
    @Operation(summary="List workflow executors")
    @ApiResponse(content={@Content(array=@ArraySchema(schema=@Schema(implementation=ListWorkflowExecutorResponse.class)))})
    public Response listWorkflowExecutors() {
        return this.handleExceptions(() -> Response.ok(this.workflowExecutors.getWorkflowExecutors().stream().map(arg_0 -> ((ListWorkflowExecutorConverter)this.converter).convert(arg_0)).collect(Collectors.toList())));
    }
}

