/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.attachment.http;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpRequestAttachment
implements AttachmentData {
    private final String name;
    private final String url;
    private final String method;
    private final String body;
    private final String curl;
    private final Map<String, String> headers;
    private final Map<String, String> cookies;

    public HttpRequestAttachment(String name, String url, String method, String body, String curl, Map<String, String> headers, Map<String, String> cookies) {
        this.name = name;
        this.url = url;
        this.method = method;
        this.body = body;
        this.curl = curl;
        this.headers = headers;
        this.cookies = cookies;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String getCurl() {
        return this.curl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "HttpRequestAttachment(\n\tname=" + this.name + ",\n\turl=" + this.url + ",\n\tbody=" + this.body + ",\n\theaders=" + ObjectUtils.mapToString(this.headers) + ",\n\tcookies=" + ObjectUtils.mapToString(this.cookies) + "\n)";
    }

    public static final class Builder {
        private final String name;
        private final String url;
        private String method;
        private String body;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> cookies = new HashMap<String, String>();

        private Builder(String name, String url) {
            Objects.requireNonNull(name, "Name must not be null value");
            Objects.requireNonNull(url, "Url must not be null value");
            this.name = name;
            this.url = url;
        }

        public static Builder create(String attachmentName, String url) {
            return new Builder(attachmentName, url);
        }

        public Builder setMethod(String method) {
            Objects.requireNonNull(method, "Method must not be null value");
            this.method = method;
            return this;
        }

        public Builder setHeader(String name, String value) {
            Objects.requireNonNull(name, "Header name must not be null value");
            Objects.requireNonNull(value, "Header value must not be null value");
            this.headers.put(name, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            Objects.requireNonNull(headers, "Headers must not be null value");
            this.headers.putAll(headers);
            return this;
        }

        public Builder setCookie(String name, String value) {
            Objects.requireNonNull(name, "Cookie name must not be null value");
            Objects.requireNonNull(value, "Cookie value must not be null value");
            this.cookies.put(name, value);
            return this;
        }

        public Builder setCookies(Map<String, String> cookies) {
            Objects.requireNonNull(cookies, "Cookies must not be null value");
            this.cookies.putAll(cookies);
            return this;
        }

        public Builder setBody(String body) {
            Objects.requireNonNull(body, "Body should not be null value");
            this.body = body;
            return this;
        }

        @Deprecated
        public Builder withMethod(String method) {
            return this.setMethod(method);
        }

        @Deprecated
        public Builder withHeader(String name, String value) {
            return this.setHeader(name, value);
        }

        @Deprecated
        public Builder withHeaders(Map<String, String> headers) {
            return this.setHeaders(headers);
        }

        @Deprecated
        public Builder withCookie(String name, String value) {
            return this.setCookie(name, value);
        }

        @Deprecated
        public Builder withCookies(Map<String, String> cookies) {
            return this.setCookies(cookies);
        }

        @Deprecated
        public Builder withBody(String body) {
            return this.setBody(body);
        }

        public HttpRequestAttachment build() {
            return new HttpRequestAttachment(this.name, this.url, this.method, this.body, this.getCurl(), this.headers, this.cookies);
        }

        private String getCurl() {
            StringBuilder builder = new StringBuilder("curl -v");
            if (Objects.nonNull(this.method)) {
                builder.append(" -X ").append(this.method);
            }
            builder.append(" '").append(this.url).append('\'');
            this.headers.forEach((key, value) -> Builder.appendHeader(builder, key, value));
            this.cookies.forEach((key, value) -> Builder.appendCookie(builder, key, value));
            if (Objects.nonNull(this.body)) {
                builder.append(" -d '").append(this.body).append('\'');
            }
            return builder.toString();
        }

        private static void appendHeader(StringBuilder builder, String key, String value) {
            builder.append(" -H '").append(key).append(": ").append(value).append('\'');
        }

        private static void appendCookie(StringBuilder builder, String key, String value) {
            builder.append(" -b '").append(key).append('=').append(value).append('\'');
        }
    }
}

