/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.deployment.recording.RecordingAnnotationsProvider;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;

final class RecordingAnnotationsUtil {
    static final List<Class<? extends Annotation>> IGNORED_PROPERTY_ANNOTATIONS;
    static final List<Class<? extends Annotation>> RECORDABLE_CONSTRUCTOR_ANNOTATIONS;

    private RecordingAnnotationsUtil() {
    }

    static boolean isIgnored(AccessibleObject object) {
        for (int i = 0; i < IGNORED_PROPERTY_ANNOTATIONS.size(); ++i) {
            Class<? extends Annotation> annotation = IGNORED_PROPERTY_ANNOTATIONS.get(i);
            if (!object.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    static boolean isRecordableConstructor(Constructor<?> ctor) {
        for (int i = 0; i < RECORDABLE_CONSTRUCTOR_ANNOTATIONS.size(); ++i) {
            Class<? extends Annotation> annotation = RECORDABLE_CONSTRUCTOR_ANNOTATIONS.get(i);
            if (!ctor.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<Class> ignoredPropertyAnnotations = new HashSet<Class>();
        ignoredPropertyAnnotations.add(IgnoreProperty.class);
        HashSet<Class> recordableConstructorAnnotations = new HashSet<Class>();
        recordableConstructorAnnotations.add(RecordableConstructor.class);
        for (RecordingAnnotationsProvider provider : ServiceLoader.load(RecordingAnnotationsProvider.class)) {
            Class<? extends Annotation> recordableConstructor;
            Class<? extends Annotation> ignoredProperty = provider.ignoredProperty();
            if (ignoredProperty != null) {
                ignoredPropertyAnnotations.add(ignoredProperty);
            }
            if ((recordableConstructor = provider.recordableConstructor()) == null) continue;
            recordableConstructorAnnotations.add(recordableConstructor);
        }
        IGNORED_PROPERTY_ANNOTATIONS = List.copyOf(ignoredPropertyAnnotations);
        RECORDABLE_CONSTRUCTOR_ANNOTATIONS = List.copyOf(recordableConstructorAnnotations);
    }
}

