/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.enforcer;

import io.quarkus.enforcer.RequiresMinimalDeploymentDependency;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRule2;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public abstract class DeploymentDependencyRuleSupport
implements EnforcerRule2 {
    protected static final String GROUP_ID_PREFIX = "io.quarkus";
    protected static final String DEPLOYMENT_ARTIFACT_ID_SUFFIX = "-deployment";
    private static final String EXT_PROPERTIES_PATH = "META-INF/quarkus-extension.properties";
    private static final Map<String, Optional<String>> DEPLOYMENT_GAV_CACHE = new ConcurrentHashMap<String, Optional<String>>();
    protected Log logger;
    private EnforcerLevel level = EnforcerLevel.ERROR;

    public final EnforcerLevel getLevel() {
        return this.level;
    }

    public final void setLevel(EnforcerLevel level) {
        this.level = level;
    }

    public final void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project;
        this.logger = helper.getLog();
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException e) {
            throw new IllegalStateException("Failed to get project from EnforcerRuleHelper", e);
        }
        if (!this.isCheckRequired(project)) {
            return;
        }
        Map<String, Artifact> nonDeploymentArtifactsByGAV = project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).filter(artifact -> artifact.getGroupId().startsWith(GROUP_ID_PREFIX)).filter(artifact -> !artifact.getArtifactId().endsWith(DEPLOYMENT_ARTIFACT_ID_SUFFIX)).collect(Collectors.toMap(this::buildGAVKey, a -> a));
        if (nonDeploymentArtifactsByGAV.values().stream().anyMatch(artifact -> !artifact.isResolved())) {
            this.logger.warn((CharSequence)("Skipping rule " + RequiresMinimalDeploymentDependency.class.getSimpleName() + ": Artifacts are not resolved, consider using a later build goal like 'package'."));
            return;
        }
        Map<String, Dependency> directDepsByGAV = project.getDependencies().stream().filter(d -> d.getGroupId().startsWith(GROUP_ID_PREFIX)).collect(Collectors.toMap(d -> d.getGroupId() + ":" + d.getArtifactId() + ":" + d.getVersion(), d -> d, (a, b) -> a));
        this.execute(project, nonDeploymentArtifactsByGAV, directDepsByGAV);
    }

    protected abstract void execute(MavenProject var1, Map<String, Artifact> var2, Map<String, Dependency> var3) throws EnforcerRuleException;

    protected final String buildGAVKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    protected final Optional<String> parseDeploymentGAV(String gav, Artifact artifact) {
        return DEPLOYMENT_GAV_CACHE.computeIfAbsent(gav, k -> this.parseDeploymentGAV(artifact));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> parseDeploymentGAV(Artifact artifact) {
        Properties extProperties;
        File artifactFile;
        block24: {
            artifactFile = artifact.getFile();
            if (artifactFile == null) throw new IllegalStateException("Artifact file not found for " + artifact);
            if (!artifactFile.exists()) {
                throw new IllegalStateException("Artifact file not found for " + artifact);
            }
            extProperties = new Properties();
            if (artifactFile.isDirectory()) {
                Path extPropertiesPath = artifactFile.toPath().resolve(EXT_PROPERTIES_PATH);
                if (!Files.exists(extPropertiesPath, new LinkOption[0])) {
                    return Optional.empty();
                }
                try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(extPropertiesPath, new OpenOption[0]), StandardCharsets.UTF_8);){
                    extProperties.load(isr);
                    break block24;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read META-INF/quarkus-extension.properties from " + artifactFile, e);
                }
            }
            try (ZipFile zipFile = new ZipFile(artifactFile);){
                ZipEntry entry = zipFile.getEntry(EXT_PROPERTIES_PATH);
                if (entry == null) {
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                try (InputStreamReader isr = new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8);){
                    extProperties.load(isr);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read META-INF/quarkus-extension.properties from " + artifactFile, e);
            }
        }
        String deploymentGAV = extProperties.getProperty("deployment-artifact");
        if (deploymentGAV != null) return Optional.of(deploymentGAV);
        throw new IllegalStateException("deployment-artifact artifact not found in META-INF/quarkus-extension.properties from " + artifactFile);
    }

    protected boolean isCheckRequired(MavenProject project) {
        return true;
    }

    public final boolean isCacheable() {
        return false;
    }

    public final boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public final String getCacheId() {
        return null;
    }
}

