/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.geo;

import io.quarkus.redis.datasource.geo.GeoPosition;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public class GeoValue<V> {
    public final V member;
    public final OptionalDouble distance;
    public final OptionalLong geohash;
    public final OptionalDouble longitude;
    public final OptionalDouble latitude;

    public GeoValue(V member, OptionalDouble distance, OptionalLong geohash, OptionalDouble longitude, OptionalDouble latitude) {
        this.member = member;
        this.distance = distance;
        this.geohash = geohash;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public V member() {
        return this.member;
    }

    public OptionalDouble distance() {
        return this.distance;
    }

    public OptionalLong geohash() {
        return this.geohash;
    }

    public OptionalDouble longitude() {
        return this.longitude;
    }

    public OptionalDouble latitude() {
        return this.latitude;
    }

    public Optional<GeoPosition> position() {
        if (this.longitude.isPresent() && this.latitude.isPresent()) {
            return Optional.of(GeoPosition.of(this.longitude.getAsDouble(), this.latitude.getAsDouble()));
        }
        return Optional.empty();
    }
}

