/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import restx.AbstractRouteLifecycleListener;
import restx.AppSettings;
import restx.RestxContext;
import restx.RestxFilter;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.StdRestxRequestMatch;
import restx.factory.Component;

@Component(priority=-100)
public class CacheFilter
implements RestxFilter {
    private final ImmutableList<String> paths;

    public CacheFilter(AppSettings settings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String s : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)settings.cachedResources())) {
            builder.add((Object)s);
        }
        this.paths = builder.build();
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRequest req) {
        for (String path : this.paths) {
            if (!req.getRestxPath().startsWith(path)) continue;
            return Optional.absent();
        }
        return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("*", req.getRestxPath()), new RestxHandler(){

            @Override
            public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                ctx.nextHandlerMatch().handle(req, resp, ctx.withListener(new AbstractRouteLifecycleListener(){

                    @Override
                    public void onBeforeWriteContent(RestxRequest req, RestxResponse resp) {
                        if (!resp.getHeader("Cache-Control").isPresent()) {
                            resp.setHeader("Cache-Control", "no-cache");
                        }
                    }
                }));
            }
        }));
    }
}

