/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.joda.time.Duration;
import restx.RestxLogLevel;
import restx.RestxResponse;
import restx.http.HttpStatus;
import restx.security.RestxSessionCookieDescriptor;

public class RestxResponseWrapper
implements RestxResponse {
    private final RestxResponse restxResponse;
    private PrintWriter writer;

    public RestxResponseWrapper(RestxResponse restxResponse) {
        this.restxResponse = restxResponse;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.getOutputStream(), (Charset)this.getCharset().or((Object)Charsets.UTF_8)), true);
        return this.writer;
    }

    @Override
    public HttpStatus getStatus() {
        return this.restxResponse.getStatus();
    }

    @Override
    public RestxResponse setStatus(HttpStatus i) {
        this.restxResponse.setStatus(i);
        return this;
    }

    @Override
    public Optional<Charset> getCharset() {
        return this.restxResponse.getCharset();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.restxResponse.getOutputStream();
    }

    @Override
    public RestxResponse setContentType(String s) {
        this.restxResponse.setContentType(s);
        return this;
    }

    @Override
    public RestxResponse addCookie(String cookie, String value, RestxSessionCookieDescriptor cookieDescriptor, Duration expires) {
        this.restxResponse.addCookie(cookie, value, cookieDescriptor, expires);
        return this;
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            finally {
                this.writer = null;
            }
        }
        this.restxResponse.close();
    }

    @Override
    public boolean isClosed() {
        return this.restxResponse.isClosed();
    }

    @Override
    public RestxResponse clearCookie(String cookie, RestxSessionCookieDescriptor cookieDescriptor) {
        this.restxResponse.clearCookie(cookie, cookieDescriptor);
        return this;
    }

    @Override
    public RestxResponse setHeader(String headerName, String header) {
        this.restxResponse.setHeader(headerName, header);
        return this;
    }

    @Override
    public Optional<String> getHeader(String headerName) {
        return this.restxResponse.getHeader(headerName);
    }

    @Override
    public RestxResponse addCookie(String cookie, String value, RestxSessionCookieDescriptor cookieDescriptor) {
        this.restxResponse.addCookie(cookie, value, cookieDescriptor);
        return this;
    }

    @Override
    public RestxResponse setLogLevel(RestxLogLevel level) {
        this.restxResponse.setLogLevel(level);
        return this;
    }

    @Override
    public RestxLogLevel getLogLevel() {
        return this.restxResponse.getLogLevel();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return this.restxResponse.unwrap(clazz);
    }
}

